/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.attestation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Signature;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"target", "predicate", "mitigationStrategies", "reasoning", "evidence", "counterEvidence", "externalReferences", "signature"})
public class Claim {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    private String target;
    private String predicate;
    private List<String> mitigationStrategies;
    private String reasoning;
    private List<String> evidence;
    private List<String> counterEvidence;
    private List<ExternalReference> externalReferences;
    private Signature signature;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    @JacksonXmlElementWrapper(localName="mitigationStrategies")
    @JacksonXmlProperty(localName="mitigationStrategy")
    public List<String> getMitigationStrategies() {
        return this.mitigationStrategies;
    }

    public void setMitigationStrategies(List<String> mitigationStrategies) {
        this.mitigationStrategies = mitigationStrategies;
    }

    public String getReasoning() {
        return this.reasoning;
    }

    public void setReasoning(String reasoning) {
        this.reasoning = reasoning;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="evidence")
    @JsonProperty(value="evidence")
    public List<String> getEvidence() {
        return this.evidence;
    }

    public void setEvidence(List<String> evidence) {
        this.evidence = evidence;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="counterEvidence")
    @JsonProperty(value="counterEvidence")
    public List<String> getCounterEvidence() {
        return this.counterEvidence;
    }

    public void setCounterEvidence(List<String> counterEvidence) {
        this.counterEvidence = counterEvidence;
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="externalReference")
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Claim)) {
            return false;
        }
        Claim claim = (Claim)object;
        return Objects.equals(this.bomRef, claim.bomRef) && Objects.equals(this.target, claim.target) && Objects.equals(this.predicate, claim.predicate) && Objects.equals(this.mitigationStrategies, claim.mitigationStrategies) && Objects.equals(this.reasoning, claim.reasoning) && Objects.equals(this.evidence, claim.evidence) && Objects.equals(this.counterEvidence, claim.counterEvidence) && Objects.equals(this.externalReferences, claim.externalReferences) && Objects.equals(this.signature, claim.signature);
    }

    public int hashCode() {
        return Objects.hash(this.bomRef, this.target, this.predicate, this.mitigationStrategies, this.reasoning, this.evidence, this.counterEvidence, this.externalReferences, this.signature);
    }
}

