/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.component.modelCard;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.component.modelCard.DatasetChoice;
import org.cyclonedx.model.component.modelCard.InputOutputParameter;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ModelParameters
extends ExtensibleElement {
    private Approach approach;
    private String task;
    private String architectureFamily;
    private String modelArchitecture;
    private List<DatasetChoice> datasets;
    private List<InputOutputParameter> inputs;
    private List<InputOutputParameter> outputs;

    public Approach getApproach() {
        return this.approach;
    }

    public void setApproach(Approach approach) {
        this.approach = approach;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getArchitectureFamily() {
        return this.architectureFamily;
    }

    public void setArchitectureFamily(String architectureFamily) {
        this.architectureFamily = architectureFamily;
    }

    public String getModelArchitecture() {
        return this.modelArchitecture;
    }

    public void setModelArchitecture(String modelArchitecture) {
        this.modelArchitecture = modelArchitecture;
    }

    @JacksonXmlElementWrapper(localName="datasets")
    @JacksonXmlProperty(localName="dataset")
    public List<DatasetChoice> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<DatasetChoice> datasets) {
        this.datasets = datasets;
    }

    @JacksonXmlElementWrapper(localName="inputs")
    @JacksonXmlProperty(localName="input")
    public List<InputOutputParameter> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputOutputParameter> inputs) {
        this.inputs = inputs;
    }

    @JacksonXmlElementWrapper(localName="outputs")
    @JacksonXmlProperty(localName="output")
    public List<InputOutputParameter> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<InputOutputParameter> outputs) {
        this.outputs = outputs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModelParameters)) {
            return false;
        }
        ModelParameters that = (ModelParameters)object;
        return Objects.equals(this.approach, that.approach) && Objects.equals(this.task, that.task) && Objects.equals(this.architectureFamily, that.architectureFamily) && Objects.equals(this.modelArchitecture, that.modelArchitecture) && Objects.equals(this.datasets, that.datasets) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.outputs, that.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.approach, this.task, this.architectureFamily, this.modelArchitecture, this.datasets, this.inputs, this.outputs);
    }

    public static class Approach {
        private ApproachType type;

        public ApproachType getType() {
            return this.type;
        }

        public void setType(ApproachType type) {
            this.type = type;
        }

        public static enum ApproachType {
            SUPERVISED("supervised"),
            UNSUPERVISED("unsupervised"),
            REINFORCEMENT_LEARNING("reinforcement-learning"),
            SEMI_SUPERVISED("semi-supervised"),
            SELF_SUPERVISED("self-supervised");

            private final String typeName;

            public String getTypeName() {
                return this.typeName;
            }

            private ApproachType(String name) {
                this.typeName = name;
            }
        }
    }
}

