/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringListDeserializer
extends JsonDeserializer<List<String>> {
    public List<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String currentName = p.getCurrentName();
        if ("aliases".equalsIgnoreCase(currentName)) {
            return this.deserializeList(node, "alias");
        }
        if ("endpoints".equalsIgnoreCase(currentName)) {
            return this.deserializeList(node, "endpoint");
        }
        if ("altIds".equalsIgnoreCase(currentName)) {
            return this.deserializeList(node, "altId");
        }
        return null;
    }

    private List<String> deserializeList(JsonNode node, String itemName) {
        JsonNode itemsNode;
        ArrayList<String> list = new ArrayList<String>();
        JsonNode jsonNode = itemsNode = node.has(itemName) ? node.get(itemName) : node;
        if (itemsNode != null) {
            if (itemsNode.isArray()) {
                for (JsonNode itemNode : itemsNode) {
                    list.add(itemNode.asText());
                }
            } else {
                list.add(itemsNode.asText());
            }
        }
        return list;
    }
}

