/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.serializer.CustomDateSerializer;
import org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import org.cyclonedx.util.serializer.LifecycleSerializer;

public class MetadataSerializer
extends StdSerializer<Metadata> {
    private final boolean isXml;
    private final Version version;

    public MetadataSerializer(boolean isXml, Version version) {
        this(null, isXml, version);
    }

    public MetadataSerializer(Class<Metadata> t, boolean isXml, Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    public void serialize(Metadata output, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createMetadataInfo(output, (JsonGenerator)xmlGenerator, serializerProvider);
        } else {
            this.createMetadataInfo(output, jsonGenerator, serializerProvider);
        }
    }

    private void createMetadataInfo(Metadata metadata, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ToXmlGenerator xmlGenerator;
        jsonGenerator.writeStartObject();
        if (metadata.getTimestamp() != null && this.shouldSerializeField(metadata, "timestamp")) {
            jsonGenerator.writeFieldName("timestamp");
            new CustomDateSerializer().serialize(metadata.getTimestamp(), jsonGenerator, serializerProvider);
        }
        if (metadata.getLifecycles() != null && this.shouldSerializeField(metadata, "lifecycles")) {
            jsonGenerator.writeFieldName("lifecycles");
            new LifecycleSerializer(this.isXml).serialize(metadata.getLifecycles(), jsonGenerator, serializerProvider);
        }
        this.parseTools(metadata, jsonGenerator);
        if (metadata.getAuthors() != null && this.shouldSerializeField(metadata, "author")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(metadata.getAuthors(), xmlGenerator, "author");
            } else {
                jsonGenerator.writeObjectField("authors", metadata.getAuthors());
            }
        }
        if (metadata.getComponent() != null && this.shouldSerializeField(metadata, "component")) {
            jsonGenerator.writeObjectField("component", (Object)metadata.getComponent());
        }
        if (metadata.getManufacturer() != null && this.shouldSerializeField(metadata, "manufacturer")) {
            jsonGenerator.writeObjectField("manufacturer", (Object)metadata.getManufacturer());
        }
        if (metadata.getManufacture() != null && this.shouldSerializeField(metadata, "manufacture")) {
            jsonGenerator.writeObjectField("manufacture", (Object)metadata.getManufacture());
        }
        if (metadata.getSupplier() != null && this.shouldSerializeField(metadata, "supplier")) {
            jsonGenerator.writeObjectField("supplier", (Object)metadata.getSupplier());
        }
        if (metadata.getLicenses() != null && this.shouldSerializeField(metadata, "licenses")) {
            jsonGenerator.writeFieldName("licenses");
            new LicenseChoiceSerializer(this.isXml, this.version).serialize(metadata.getLicenses(), jsonGenerator, serializerProvider);
        }
        if (CollectionUtils.isNotEmpty(metadata.getProperties()) && this.shouldSerializeField(metadata, "properties")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                xmlGenerator.writeFieldName("properties");
                xmlGenerator.writeStartObject();
                for (Property property : metadata.getProperties()) {
                    xmlGenerator.writeObjectField("property", (Object)property);
                }
                xmlGenerator.writeEndObject();
            } else {
                jsonGenerator.writeObjectField("properties", metadata.getProperties());
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void parseTools(Metadata metadata, JsonGenerator jsonGenerator) throws IOException {
        ToolInformation choice;
        if (metadata.getTools() != null) {
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                this.writeArrayFieldXML(metadata.getTools(), (ToXmlGenerator)jsonGenerator, "tool");
            } else {
                this.writeArrayFieldJSON(jsonGenerator, "tools", metadata.getTools());
            }
        } else if (this.version.getVersion() >= Version.VERSION_15.getVersion() && (choice = metadata.getToolChoice()) != null) {
            jsonGenerator.writeFieldName("tools");
            jsonGenerator.writeStartObject();
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldXML(choice.getComponents(), (ToXmlGenerator)jsonGenerator, "component");
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldXML(choice.getServices(), (ToXmlGenerator)jsonGenerator, "service");
                }
            } else {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "components", choice.getComponents());
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "services", choice.getServices());
                }
            }
            jsonGenerator.writeEndObject();
        }
    }

    private <T> void writeArrayFieldJSON(JsonGenerator jsonGenerator, String fieldName, List<T> items) throws IOException {
        if (items != null) {
            jsonGenerator.writeArrayFieldStart(fieldName);
            for (T item : items) {
                jsonGenerator.writeObject(item);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private <T> void writeArrayFieldXML(List<T> items, ToXmlGenerator xmlGenerator, String fieldName) throws IOException {
        if (items != null) {
            xmlGenerator.writeFieldName(fieldName + "s");
            xmlGenerator.writeStartArray();
            for (T item : items) {
                xmlGenerator.writeStartObject();
                xmlGenerator.writeObjectField(fieldName, item);
                xmlGenerator.writeEndObject();
            }
            xmlGenerator.writeEndArray();
        }
    }

    private boolean shouldSerializeField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            VersionFilter filter = field.getAnnotation(VersionFilter.class);
            return filter == null || filter.value().getVersion() <= this.version.getVersion();
        }
        catch (NoSuchFieldException e) {
            return true;
        }
    }

    public Class<Metadata> handledType() {
        return Metadata.class;
    }
}

