/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import org.dacapo.harness.CommandLineArgs;
import org.dacapo.harness.TestHarness;
import org.dacapo.parser.Config;

public class Callback {
    protected Mode mode;
    protected final CommandLineArgs args;
    protected int iterations;
    protected long[] times;
    protected long timer;
    protected long elapsed;
    boolean verbose = false;

    public Callback(CommandLineArgs args) {
        this.args = args;
        if (args.getMethodology() == CommandLineArgs.Methodology.CONVERGE) {
            this.times = new long[args.getWindow()];
        }
        this.verbose |= args.getDebug();
    }

    public void init(Config config) {
        if (this.verbose) {
            System.out.println("Initializing callback");
        }
        this.iterations = 0;
        switch (this.args.getMethodology()) {
            case ITERATE: {
                if (this.args.getIterations() == 1) {
                    this.mode = Mode.TIMING;
                    break;
                }
                this.mode = Mode.WARMUP;
                break;
            }
            case CONVERGE: {
                this.mode = this.args.getWindow() == 0 ? Mode.TIMING : Mode.WARMUP;
            }
        }
        if (this.times != null) {
            for (int i = 0; i < this.times.length; ++i) {
                this.times[i] = 0L;
            }
        }
    }

    public boolean runAgain() {
        if (this.verbose) {
            System.out.println("runAgain");
        }
        if (!this.isWarmup()) {
            return false;
        }
        ++this.iterations;
        if (this.verbose) {
            System.out.println("iterations = " + this.iterations);
        }
        switch (this.args.getMethodology()) {
            case ITERATE: {
                if (this.iterations == this.args.getIterations() - 1) {
                    this.mode = Mode.TIMING;
                }
                if (this.verbose) {
                    System.out.println("mode = " + (Object)((Object)this.mode));
                }
                return true;
            }
            case CONVERGE: {
                if (this.iterations >= this.args.getMaxIterations()) {
                    System.err.println("Benchmark failed to converge.");
                    return false;
                }
                this.times[(this.iterations - 1) % this.args.getWindow()] = this.elapsed;
                if (this.iterations < this.args.getWindow()) {
                    return true;
                }
                if (this.iterations >= this.args.getWindow() && this.args.getVerbose()) {
                    System.err.printf("Variation %4.2f%% achieved after %d iterations, target = %4.2f%%\n", TestHarness.coeff_of_var(this.times) * 100.0, this.iterations, this.args.getTargetVar() * 100.0);
                }
                if (TestHarness.coeff_of_var(this.times) > this.args.getTargetVar()) {
                    return true;
                }
                this.mode = Mode.TIMING;
                return true;
            }
        }
        assert (false);
        return false;
    }

    public boolean isWarmup() {
        return this.mode == Mode.WARMUP;
    }

    public void start(String benchmark) {
        this.start(benchmark, this.mode == Mode.WARMUP);
    }

    @Deprecated
    public void startWarmup(String benchmark) {
        this.start(benchmark, true);
    }

    protected void start(String benchmark, boolean warmup) {
        this.timer = System.currentTimeMillis();
        System.err.print("===== DaCapo " + TestHarness.getBuildVersion() + " " + benchmark + " starting ");
        System.err.println((warmup ? "warmup " + (this.iterations + 1) + " " : "") + "=====");
        System.err.flush();
    }

    public void stop() {
        this.stop(this.mode == Mode.WARMUP);
    }

    @Deprecated
    public void stopWarmup() {
        this.stop(true);
    }

    public void stop(boolean warmup) {
        this.elapsed = System.currentTimeMillis() - this.timer;
    }

    public void complete(String benchmark, boolean valid) {
        this.complete(benchmark, valid, this.mode == Mode.WARMUP);
    }

    @Deprecated
    public void completeWarmup(String benchmark, boolean valid) {
        this.complete(benchmark, valid, true);
    }

    protected void complete(String benchmark, boolean valid, boolean warmup) {
        System.err.print("===== DaCapo " + TestHarness.getBuildVersion() + " " + benchmark);
        if (valid) {
            System.err.print(warmup ? " completed warmup " + (this.iterations + 1) + " " : " PASSED ");
            System.err.print("in " + this.elapsed + " msec ");
        } else {
            System.err.print(" FAILED " + (warmup ? "warmup " : ""));
        }
        System.err.println("=====");
        System.err.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        WARMUP,
        TIMING;

    }
}

