/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Method;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Jython
extends Benchmark {
    private Method pySetArgsMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jython(Config config, File scratch) throws Exception {
        super(config, scratch);
        Class<?> clazz = Class.forName("org.python.util.jython", true, this.loader);
        this.method = clazz.getMethod("main", String[].class);
        Class<?> pyClass = Class.forName("org.python.core.PySystemState", true, this.loader);
        this.pySetArgsMethod = pyClass.getMethod("setArgv", String[].class);
        System.setProperty("python.home", this.fileInScratch("jython"));
        System.setProperty("python.cachedir", this.fileInScratch("cachedir"));
        System.setProperty("python.verbose", "warning");
        this.useBenchmarkClassLoader();
        try {
            this.method.invoke(null, new Object[]{new String[]{this.fileInScratch("jython/noop.py")}});
        }
        finally {
            this.revertClassLoader();
        }
    }

    public void iterate(String size) throws Exception {
        String[] args = this.config.preprocessArgs(size, this.scratch);
        this.pySetArgsMethod.invoke(null, new Object[]{args});
        this.method.invoke(null, new Object[]{args});
    }

    public void cleanup() {
        super.cleanup();
        Jython.deleteTree(new File(this.scratch, "cachedir"));
    }
}

