/*
 * Decompiled with CFR 0.152.
 */
package org.dacapo.harness;

import java.io.File;
import java.lang.reflect.Constructor;
import org.dacapo.harness.Benchmark;
import org.dacapo.parser.Config;

public class Tomcat
extends Benchmark {
    private static final int PORT = 7080;
    private final Class<?> clazz;
    private final Constructor<Runnable> clientConstructor;
    private final Object controller;

    public Tomcat(Config config, File scratch) throws Exception {
        super(config, scratch, false);
        this.clazz = Class.forName("org.dacapo.tomcat.Control", true, this.loader);
        this.method = this.clazz.getMethod("exec", String.class);
        Constructor<?> controlConstructor = this.clazz.getConstructor(File.class, ClassLoader.class, Integer.TYPE);
        this.controller = controlConstructor.newInstance(scratch, this.loader, 7080);
        Class<?> clientClass = Class.forName("org.dacapo.tomcat.Client", true, this.loader);
        this.clientConstructor = clientClass.getConstructor(File.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(String size) throws Exception {
        super.prepare(size);
        try {
            this.useBenchmarkClassLoader();
            try {
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
                System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "info");
                System.setProperty("catalina.home", this.scratch.getAbsolutePath());
                System.setProperty("catalina.config", new File(this.fileInScratch("catalina.properties")).toURL().toExternalForm());
                this.method.invoke(this.controller, "prepare");
                System.out.println("Server thread created");
            }
            finally {
                this.revertClassLoader();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postIteration(String size) throws Exception {
        super.postIteration(size);
    }

    public void iterate(String size) throws Exception {
        int i;
        System.out.println("Loading web application");
        this.method.invoke(this.controller, "startIteration");
        int threadCount = this.config.getThreadCount(size);
        String[] args = this.config.getArgs(size);
        int iterations = Integer.parseInt(args[0]);
        int iterationsPerClient = iterations / threadCount;
        int oddIterations = iterations - iterationsPerClient * threadCount;
        Thread[] threads = new Thread[threadCount];
        System.out.println("Creating client threads");
        for (i = 0; i < threadCount; ++i) {
            Runnable client = this.clientConstructor.newInstance(this.scratch, i, iterationsPerClient + (i < oddIterations ? 1 : 0), Tomcat.getVerbose(), 7080);
            threads[i] = new Thread(client);
            threads[i].start();
        }
        System.out.println("Waiting for clients to complete");
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        System.out.println("Client threads complete ... unloading web application");
        this.method.invoke(this.controller, "stopIteration");
    }

    protected void postIterationCleanup(String size) {
        super.postIterationCleanup(size);
        Tomcat.deleteTree(new File(this.scratch, "work"));
    }

    public void cleanup() {
        try {
            this.method.invoke(this.controller, "cleanup");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("Server stopped ... iteration complete");
        super.cleanup();
    }

    private void dumpThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        int nThreads = tg.activeCount();
        Thread[] threads = new Thread[nThreads * 2];
        nThreads = Thread.enumerate(threads);
        System.out.printf("==================== Dumping %d Threads: ====================%n", nThreads);
        System.out.flush();
        for (int i = 0; i < nThreads; ++i) {
            if (threads[i] != null) {
                System.out.print(threads[i].getName() + ": ");
                StackTraceElement[] stack = threads[i].getStackTrace();
                for (int j = 0; j < stack.length; ++j) {
                    for (int k = 0; k < j; ++k) {
                        System.out.print("  ");
                    }
                    System.out.println(stack[j].getClassName() + "." + stack[j].getMethodName() + ":" + stack[j].getLineNumber() + " <- ");
                }
            } else {
                System.out.print("null ");
            }
            System.out.flush();
        }
        System.out.println();
        System.out.flush();
        System.out.printf("==================== Thread Dump End ====================%n", new Object[0]);
    }
}

