/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer;

import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class ColumnSettings {
    public static final String NUMBER_PATTERN = "#,##0.00";
    public static final String EXPRESSION = "value";
    public static final String DATE_PATTERN = "MMM dd, yyyy HH:mm";
    public static final String DATE_YEAR = "yyyy";
    public static final String DATE_MONTH = "MMM yyyy";
    public static final String DATE_QUARTER = "MMM yyyy";
    public static final String DATE_DAY = "dd MMM";
    public static final String DATE_WEEK = "'Week' dd MMM";
    public static final String DATE_HOUR = "HH'h'";
    public static final String DATE_MINUTE = "mm'm'";
    public static final String DATE_SECOND = "ss's'";
    protected String columnId;
    protected String columnName;
    protected String valueExpression;
    protected String emptyTemplate;
    protected String valuePattern;

    public static String getFixedExpression(DateIntervalType type) {
        if (DateIntervalType.SECOND.equals((Object)type)) {
            return "value + \"\\\"\"";
        }
        if (DateIntervalType.MINUTE.equals((Object)type)) {
            return "value + \"'\"";
        }
        if (DateIntervalType.HOUR.equals((Object)type)) {
            return "value + \"h\"";
        }
        if (DateIntervalType.QUARTER.equals((Object)type)) {
            return "\"Q\" + value";
        }
        return EXPRESSION;
    }

    public static String getDatePattern(DateIntervalType type) {
        if (type.getIndex() <= DateIntervalType.SECOND.getIndex()) {
            return DATE_SECOND;
        }
        if (DateIntervalType.MINUTE.equals((Object)type)) {
            return DATE_MINUTE;
        }
        if (DateIntervalType.HOUR.equals((Object)type)) {
            return DATE_HOUR;
        }
        if (DateIntervalType.DAY.equals((Object)type)) {
            return DATE_DAY;
        }
        if (DateIntervalType.WEEK.equals((Object)type)) {
            return DATE_WEEK;
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            return "MMM yyyy";
        }
        if (DateIntervalType.QUARTER.equals((Object)type)) {
            return "MMM yyyy";
        }
        return DATE_YEAR;
    }

    public static ColumnSettings cloneWithDefaults(ColumnSettings columnSettings, DataColumn column) {
        ColumnSettings clone = columnSettings == null ? new ColumnSettings(column.getId()) : columnSettings.cloneInstance();
        ColumnType columnType = column.getColumnType();
        ColumnGroup columnGroup = column.getColumnGroup();
        DateIntervalType intervalType = DateIntervalType.getByName((String)column.getIntervalType());
        if (clone.columnName == null) {
            clone.columnName = column.getId();
        }
        if (clone.emptyTemplate == null) {
            clone.emptyTemplate = "---";
        }
        if (clone.valuePattern == null) {
            if (intervalType != null && columnGroup.getStrategy().equals((Object)GroupStrategy.DYNAMIC)) {
                clone.valuePattern = ColumnSettings.getDatePattern(intervalType);
            } else if (ColumnType.DATE.equals((Object)columnType)) {
                clone.valuePattern = DATE_PATTERN;
            } else if (ColumnType.NUMBER.equals((Object)columnType)) {
                clone.valuePattern = NUMBER_PATTERN;
            }
        }
        if (clone.valueExpression == null) {
            if (intervalType != null && columnGroup.getStrategy().equals((Object)GroupStrategy.FIXED)) {
                clone.valueExpression = ColumnSettings.getFixedExpression(intervalType);
            } else if (!ColumnType.DATE.equals((Object)columnType)) {
                clone.valueExpression = EXPRESSION;
            }
        }
        return clone;
    }

    public ColumnSettings() {
    }

    public ColumnSettings(String columnId) {
        this.columnId = columnId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String name) {
        this.columnName = name;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getValuePattern() {
        return this.valuePattern;
    }

    public void setValuePattern(String pattern) {
        this.valuePattern = pattern;
    }

    public String getEmptyTemplate() {
        return this.emptyTemplate;
    }

    public void setEmptyTemplate(String emptyTemplate) {
        this.emptyTemplate = emptyTemplate;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.columnId != null) {
            out.append(this.columnId).append(" ");
        }
        if (this.columnName != null) {
            out.append(this.columnName).append(" ");
        }
        if (this.valuePattern != null) {
            out.append(this.valuePattern).append(" ");
        }
        if (this.valueExpression != null) {
            out.append(this.valueExpression).append(" ");
        }
        if (this.emptyTemplate != null) {
            out.append(this.emptyTemplate).append(" ");
        }
        return out.toString();
    }

    public ColumnSettings cloneInstance() {
        ColumnSettings other = new ColumnSettings();
        other.columnId = this.columnId;
        other.columnName = this.columnName;
        other.valuePattern = this.valuePattern;
        other.valueExpression = this.valueExpression;
        other.emptyTemplate = this.emptyTemplate;
        return other;
    }

    public boolean equals(Object obj) {
        try {
            ColumnSettings other = (ColumnSettings)obj;
            if (other == null) {
                return false;
            }
            if (this.columnId != null && !this.columnId.equals(other.columnId)) {
                return false;
            }
            if (this.columnName != null && !this.columnName.equals(other.columnName)) {
                return false;
            }
            if (this.valuePattern != null && !this.valuePattern.equals(other.valuePattern)) {
                return false;
            }
            if (this.valueExpression != null && !this.valueExpression.equals(other.valueExpression)) {
                return false;
            }
            return this.emptyTemplate == null || this.emptyTemplate.equals(other.emptyTemplate);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

