/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.components.internal.ProvidedComponentInfo;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ComponentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ComponentLoaderImpl
implements ComponentLoader {
    Logger logger = LoggerFactory.getLogger(ComponentLoaderImpl.class);
    public static final String EXTERNAL_COMP_DIR_PROP = "dashbuilder.components.dir";
    public static final String EXTERNAL_COMP_ENABLE_PROP = "dashbuilder.components.enable";
    private static final String DEFAULT_COMPONENTS_PATH = "/tmp/dashbuilder/components/";
    private ProvidedComponentInfo providedComponentsInfo;
    private String externalComponentsDir;
    private Gson gson;
    private boolean externalComponentEnabled;

    @PostConstruct
    public void init() {
        Path baseDirPath;
        this.gson = new Gson();
        this.providedComponentsInfo = ProvidedComponentInfo.get();
        this.externalComponentEnabled = Boolean.parseBoolean(System.getProperty(EXTERNAL_COMP_ENABLE_PROP, Boolean.FALSE.toString()));
        this.externalComponentsDir = System.getProperty(EXTERNAL_COMP_DIR_PROP, DEFAULT_COMPONENTS_PATH);
        if (this.externalComponentEnabled && !(baseDirPath = Paths.get(this.externalComponentsDir, new String[0])).toFile().exists()) {
            baseDirPath.toFile().mkdirs();
        }
    }

    public List<ExternalComponent> loadProvided() {
        return this.providedComponentsInfo.getInternalComponentsList().stream().map(this::readInternalComponent).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ExternalComponent> loadExternal() {
        if (this.externalComponentEnabled) {
            List<ExternalComponent> list;
            block9: {
                Stream<Path> walker = Files.walk(Paths.get(this.externalComponentsDir, new String[0]), 1, new FileVisitOption[0]);
                try {
                    list = walker.filter(p -> p.toFile().isDirectory()).map(this::getComponentDescriptor).filter(File::exists).map(this::readComponent).filter(Objects::nonNull).collect(Collectors.toList());
                    if (walker == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walker != null) {
                            try {
                                walker.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.error("Error loading components from {}. Error: {}", (Object)this.externalComponentsDir, (Object)e.getMessage());
                        this.logger.debug("Error loading external components.", (Throwable)e);
                    }
                }
                walker.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public String getExternalComponentsDir() {
        return this.externalComponentsDir;
    }

    public String getProvidedComponentsPath() {
        return this.providedComponentsInfo.getInternalComponentsRootPath();
    }

    private ExternalComponent readInternalComponent(String componentId) {
        String internalComponentDescriptor = "/" + this.providedComponentsInfo.getInternalComponentsRootPath() + "/" + componentId + "/" + "manifest.json";
        InputStream is = this.getClass().getResourceAsStream(internalComponentDescriptor);
        if (is == null) {
            this.logger.error("Not able to read internal component manifest file for component {}", (Object)componentId);
            return null;
        }
        return this.readComponent(componentId, new InputStreamReader(is));
    }

    private ExternalComponent readComponent(File file) {
        String id = file.getParentFile().getName();
        try {
            FileReader reader = new FileReader(file);
            return this.readComponent(id, reader);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Not able to read component manifest file {}. Error: {}", (Object)file.getPath(), (Object)e.getMessage());
            this.logger.debug("Error reading component file.", (Throwable)e);
            return null;
        }
    }

    private ExternalComponent readComponent(String componentId, Reader manifestReader) {
        try {
            ExternalComponent component = (ExternalComponent)this.gson.fromJson(manifestReader, ExternalComponent.class);
            component.setId(componentId);
            return component;
        }
        catch (Exception e) {
            this.logger.error("Not able to load component {}. Error: {}", (Object)componentId, (Object)e.getMessage());
            this.logger.debug("Error reading component.", (Throwable)e);
            return null;
        }
    }

    private File getComponentDescriptor(Path p) {
        return Paths.get(p.toString(), "manifest.json").toFile();
    }

    public boolean isExternalComponentsEnabled() {
        return this.externalComponentEnabled;
    }
}

