/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.impl;

import java.util.Stack;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavFactory;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemContext;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.impl.NavTreeImpl;

public class NavTreeBuilder {
    NavFactory factory = NavFactory.get();
    Stack<NavGroup> stack = new Stack();
    NavGroup root = this.factory.createNavGroup();

    public NavTreeBuilder() {
        this.stack.push(this.root);
    }

    public NavTreeBuilder group(String id, String name, String description, boolean modifiable) {
        NavGroup item = this.factory.createNavGroup();
        item.setId(id);
        item.setName(name);
        item.setDescription(description);
        item.setModifiable(modifiable);
        this.stackGroup(item);
        return this;
    }

    public NavTreeBuilder item(String id, String name, String description, boolean modifiable) {
        return this.item(id, name, description, modifiable, (String)null);
    }

    public NavTreeBuilder item(String id, String name, String description, boolean modifiable, NavItemContext itemCtx) {
        return this.item(id, name, description, modifiable, itemCtx != null ? itemCtx.toString() : null);
    }

    public NavTreeBuilder item(String id, String name, String description, boolean modifiable, String itemCtx) {
        NavItem item = this.factory.createNavItem();
        item.setId(id);
        item.setName(name);
        item.setDescription(description);
        item.setModifiable(modifiable);
        item.setContext(itemCtx);
        this.stackItem(item);
        return this;
    }

    public NavTreeBuilder divider() {
        NavDivider item = this.factory.createDivider();
        item.setId(Integer.toString(item.hashCode()));
        this.stackItem(item);
        return this;
    }

    public NavTreeBuilder endGroup() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Call group first");
        }
        this.stack.pop();
        return this;
    }

    public NavTree build() {
        return new NavTreeImpl(this.root);
    }

    private void stackGroup(NavGroup item) {
        this.stackItem(item);
        this.stack.push(item);
    }

    private void stackItem(NavItem item) {
        NavGroup group = this.stack.peek();
        item.setParent(group == this.root ? null : group);
        group.getChildren().add(item);
    }
}

