/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.service;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.DataSetManagerCDI;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.backend.EditDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.service.DataSetDefVfsServices;
import org.dashbuilder.exception.ExceptionManager;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
@Service
public class DataSetDefVfsServicesImpl
implements DataSetDefVfsServices {
    private static final String SYSTEM = "system";
    protected User identity;
    protected DataSetDefRegistryCDI dataSetDefRegistry;
    protected DataSetManagerCDI dataSetManager;
    protected ExceptionManager exceptionManager;

    public DataSetDefVfsServicesImpl() {
    }

    @Inject
    public DataSetDefVfsServicesImpl(User identity, DataSetDefRegistryCDI dataSetDefRegistry, DataSetManagerCDI dataSetManager, ExceptionManager exceptionManager) {
        this.identity = identity;
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.dataSetManager = dataSetManager;
        this.exceptionManager = exceptionManager;
    }

    public Path resolve(DataSetDef dataSetDef) {
        return this.dataSetDefRegistry.resolveVfsPath(dataSetDef);
    }

    public DataSetDef get(Path path) {
        return this.dataSetDefRegistry.loadDataSetDef(path);
    }

    public EditDataSetDef load(Path path) {
        try {
            DataSetDef def = this.dataSetDefRegistry.loadDataSetDef(path);
            if (def == null) {
                return null;
            }
            DataSetDef cloned = def.clone();
            boolean clonedAllColumns = cloned.isAllColumnsEnabled();
            List clonedColumns = cloned.getColumns();
            cloned.setAllColumnsEnabled(true);
            cloned.setColumns(null);
            DataSetMetadata _cd = this.dataSetManager.resolveProvider(cloned).getDataSetMetadata(cloned);
            ArrayList<DataColumnDef> columns = new ArrayList<DataColumnDef>();
            if (_cd.getNumberOfColumns() > 0) {
                for (int x = 0; x < _cd.getNumberOfColumns(); ++x) {
                    String cId = _cd.getColumnId(x);
                    ColumnType cType = _cd.getColumnType(x);
                    DataColumnDef cdef = new DataColumnDef(cId, cType);
                    columns.add(cdef);
                }
            }
            cloned.setAllColumnsEnabled(clonedAllColumns);
            cloned.setColumns(clonedColumns);
            return new EditDataSetDef(cloned, columns);
        }
        catch (Exception e) {
            throw this.exceptionManager.handleException(e);
        }
    }

    public Path save(DataSetDef definition, String commitMessage) {
        this.dataSetDefRegistry.registerDataSetDef(definition, this.identity != null ? this.identity.getIdentifier() : SYSTEM, commitMessage);
        return this.dataSetDefRegistry.resolveVfsPath(definition);
    }

    public Path copy(Path path, String newName, String commitMessage) {
        DataSetDef def = this.dataSetDefRegistry.loadDataSetDef(path);
        if (def == null) {
            throw this.exceptionManager.handleException(new Exception("Data set definition not found: " + path.getFileName()));
        }
        DataSetDef clone = this.dataSetDefRegistry.copyDataSetDef(def, newName, this.identity != null ? this.identity.getIdentifier() : SYSTEM, commitMessage);
        return this.dataSetDefRegistry.resolveVfsPath(clone);
    }

    public Path copy(Path path, String newName, Path targetDirectory, String comment) {
        if (targetDirectory == null) {
            return this.copy(path, newName, comment);
        }
        throw new UnsupportedOperationException("A data set definition cannot be copied to another directory.");
    }

    public void delete(Path path, String commitMessage) {
        this.dataSetDefRegistry.removeDataSetDef(path, this.identity != null ? this.identity.getIdentifier() : SYSTEM, commitMessage);
    }
}

