/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.util.ContiPerfUtil;

public class PerformanceRequirement {
    private int average;
    private int max;
    private int totalTime;
    private int throughput;
    private PercentileRequirement[] percentiles;

    public PerformanceRequirement() {
        this(-1, -1, -1, new PercentileRequirement[0], -1);
    }

    public PerformanceRequirement(int average, int max, int totalTime, PercentileRequirement[] percentiles, int throughput) {
        this.average = average;
        this.max = max;
        this.totalTime = totalTime;
        this.percentiles = percentiles;
        this.throughput = throughput;
    }

    public int getAverage() {
        return this.average;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public PercentileRequirement[] getPercentileRequirements() {
        return this.percentiles;
    }

    public void setPercentileValues(PercentileRequirement[] percentiles) {
        this.percentiles = percentiles;
    }

    public int getThroughput() {
        return this.throughput;
    }

    public void setPercentiles(String percentilesSpec) {
        this.setPercentileValues(ContiPerfUtil.parsePercentiles(percentilesSpec));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("average=").append(this.average);
        builder.append(", max=").append(this.max);
        builder.append(", totalTime=").append(this.totalTime);
        builder.append(", throughput=").append(this.throughput);
        builder.append(", percentiles=").append(this.percentiles);
        return builder.toString();
    }
}

