/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
    ...
**********************************************************************/
package org.datanucleus;

import java.util.Map;

/**
 * Factory for connections to the datastore.
 * To be implemented by all StoreManagers.
 *
 * @version $Revision: 1.13 $
 */
public interface ConnectionFactory
{
    /**
     * Obtain a connection from the Factory. The connection will be enlisted within the {@link org.datanucleus.Transaction} 
     * associated to the {@link org.datanucleus.ObjectManager} <code>om</code> if "enlist" is set to true.
     * @param om the {@link org.datanucleus.ObjectManager} or null
     * @param options Any options for then creating the connection
     * @return the {@link org.datanucleus.ManagedConnection}
     */
    ManagedConnection getConnection(ObjectManager om, Map options);

    /**
     * Create the ManagedConnection.
     * Only used by ConnectionManager so do not call this.
     * @param om ObjectManager (if any)
     * @param transactionOptions the Transaction options this connection will be enlisted to, null if non existent
     * @return The ManagedConnection.
     */
    ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions);
}