/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2008 Andy Jefferson - merged into single method
     ...
 **********************************************************************/
package org.datanucleus;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.PersistenceCapable;

import org.datanucleus.jdo.JDOPersistenceManager;

/**
 * Helper methods for accessing the ObjectManager for particular objects.
 */
public class ObjectManagerHelper
{
    /**
     * Accessor for the ObjectManager for an Object.
     * @param obj The Object
     * @return The ObjectManager
     */
    public static ObjectManager getObjectManager(Object obj)
    {
        if (obj == null)
        {
            return null;
        }

        // TODO Try to avoid JDO-specific class usage here
        if (obj instanceof PersistenceCapable)
        {
            PersistenceManager pm = JDOHelper.getPersistenceManager(obj);
            if (pm == null)
            {
                return null;
            }
            return ((JDOPersistenceManager)pm).getObjectManager();
        }
        else if (obj instanceof PersistenceManager)
        {
            return ((JDOPersistenceManager)obj).getObjectManager();
        }

        return null;
    }
}