/******************************************************************
Copyright (c) 2004 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
*****************************************************************/
package org.datanucleus.jdo.metadata;

import org.datanucleus.util.AbstractXMLEntityResolver;

/**
 * Implementation of an entity resolver for JDO metadata files.
 * Handles JDO1, JDO2, JDO2 ORM, and JDO2 Query entity resolution.
 */
public class JDOEntityResolver extends AbstractXMLEntityResolver
{
    /** Public Key for JDO 1.0 */
    private static final String PUBLIC_ID_KEY_JDO_1_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 1.0//EN";

    /** Public Key for JDO 2.0 */
    private static final String PUBLIC_ID_KEY_JDO_2_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.0//EN";

    /** Public Key for JDO 2.1 */
    private static final String PUBLIC_ID_KEY_JDO_2_1 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.1//EN";

    /** Public Key for JDO 2.2 */
    private static final String PUBLIC_ID_KEY_JDO_2_2 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.2//EN";

    /** Public Key for ORM 2.0 */
    private static final String PUBLIC_ID_KEY_ORM_2_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Mapping Metadata 2.0//EN";

    /** Public Key for ORM 2.1 */
    private static final String PUBLIC_ID_KEY_ORM_2_1 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Mapping Metadata 2.1//EN";

    /** Public Key for ORM 2.2 */
    private static final String PUBLIC_ID_KEY_ORM_2_2 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Mapping Metadata 2.2//EN";

    /** Public Key for JDOQUERY 2.0 */
    private static final String PUBLIC_ID_KEY_JDOQUERY_2_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Query Metadata 2.0//EN";

    /** Public Key for JDOQUERY 2.1 */
    private static final String PUBLIC_ID_KEY_JDOQUERY_2_1 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Query Metadata 2.1//EN";

    /** Public Key for JDOQUERY 2.2 */
    private static final String PUBLIC_ID_KEY_JDOQUERY_2_2 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Query Metadata 2.2//EN";

    public JDOEntityResolver()
    {
        // Add definitions for internally supported URLs
        publicIdEntities.put(PUBLIC_ID_KEY_JDO_1_0, "/org/datanucleus/jdo/jdo_1_0.dtd");
        publicIdEntities.put(PUBLIC_ID_KEY_JDO_2_0, "/org/datanucleus/jdo/jdo_2_0.dtd");
        publicIdEntities.put(PUBLIC_ID_KEY_JDO_2_1, "/org/datanucleus/jdo/jdo_2_0.dtd"); // No JDO 2.1 DTD
        publicIdEntities.put(PUBLIC_ID_KEY_JDO_2_2, "/org/datanucleus/jdo/jdo_2_2.dtd");

        publicIdEntities.put(PUBLIC_ID_KEY_ORM_2_0, "/org/datanucleus/jdo/jdo_orm_2_0.dtd");
        publicIdEntities.put(PUBLIC_ID_KEY_ORM_2_1, "/org/datanucleus/jdo/jdo_orm_2_0.dtd"); // No JDO 2.1 DTD
        publicIdEntities.put(PUBLIC_ID_KEY_ORM_2_2, "/org/datanucleus/jdo/jdo_orm_2_2.dtd");

        publicIdEntities.put(PUBLIC_ID_KEY_JDOQUERY_2_0, "/org/datanucleus/jdo/jdoquery_2_0.dtd");
        publicIdEntities.put(PUBLIC_ID_KEY_JDOQUERY_2_1, "/org/datanucleus/jdo/jdoquery_2_0.dtd"); // No JDO 2.1 DTD
        publicIdEntities.put(PUBLIC_ID_KEY_JDOQUERY_2_2, "/org/datanucleus/jdo/jdoquery_2_2.dtd");

        systemIdEntities.put(PUBLIC_ID_KEY_JDO_1_0, "/org/datanucleus/jdo/jdo_1_0.dtd");
        systemIdEntities.put(PUBLIC_ID_KEY_JDO_2_0, "/org/datanucleus/jdo/jdo_2_0.dtd");
        systemIdEntities.put(PUBLIC_ID_KEY_JDO_2_1, "/org/datanucleus/jdo/jdo_2_0.dtd"); // No JDO 2.1 DTD
        systemIdEntities.put(PUBLIC_ID_KEY_JDO_2_2, "/org/datanucleus/jdo/jdo_2_2.dtd");

        systemIdEntities.put("file:/javax/jdo/jdo.dtd", "/org/datanucleus/jdo/jdo_2_2.dtd");
        systemIdEntities.put("file:/javax/jdo/orm.dtd", "/org/datanucleus/jdo/jdo_orm_2_2.dtd");
        systemIdEntities.put("file:/javax/jdo/jdoquery.dtd", "/org/datanucleus/jdo/jdoquery_2_2.dtd");

        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdo_2_0.xsd", "/org/datanucleus/jdo/jdo_2_0.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdo_2_1.xsd", "/org/datanucleus/jdo/jdo_2_1.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdo_2_2.xsd", "/org/datanucleus/jdo/jdo_2_2.xsd");

        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/orm_2_0.xsd", "/org/datanucleus/jdo/jdo_orm_2_0.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/orm_2_1.xsd", "/org/datanucleus/jdo/jdo_orm_2_1.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/orm_2_2.xsd", "/org/datanucleus/jdo/jdo_orm_2_2.xsd");

        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdoquery_2_0.xsd", "/org/datanucleus/jdo/jdoquery_2_0.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdoquery_2_1.xsd", "/org/datanucleus/jdo/jdoquery_2_1.xsd");
        systemIdEntities.put("http://java.sun.com/xml/ns/jdo/jdoquery_2_2.xsd", "/org/datanucleus/jdo/jdoquery_2_2.xsd");
    }
}