/**********************************************************************
Copyright (c) 2004 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2004 Andy Jefferson - added initialise() method
    ...
**********************************************************************/
package org.datanucleus.metadata;

/**
 * Representation of the Meta-Data defining inherited classes.
 *
 * @since 1.1 
 * @version $Revision: 1.9 $
 */
public class InheritanceMetaData extends MetaData
{
    /** strategy tag value. */
    protected InheritanceStrategy strategy=null;

    /** JoinMetaData element. */
    protected JoinMetaData joinMetaData;

    /** DiscriminatorMetaData element. */
    protected DiscriminatorMetaData discriminatorMetaData;

    /** Strategy to apply for the whole inheritance tree. Optional, used by JPA. */
    protected String strategyForTree = null;

    /**
     * Constructor.AbstractClassMetaData
     * @param parent parent ClassMetaData instance
     * @param strategy Inheritance strategy
     */
    public InheritanceMetaData(AbstractClassMetaData parent,
                               final String strategy)
    {
        super(parent);

        this.strategy = InheritanceStrategy.getInheritanceStrategy(strategy);
    }

    /**
     * Method to initialise the object, creating internal convenience arrays.
     * Initialises all sub-objects.
     */
    public void initialise()
    {
        if (joinMetaData != null)
        {
            joinMetaData.initialise();
        }

        if (discriminatorMetaData != null)
        {
            discriminatorMetaData.initialise();
        }

        setInitialised();
    }

    public void setStrategyForTree(String strategy)
    {
        this.strategyForTree = strategy;
    }

    public String getStrategyForTree()
    {
        return strategyForTree;
    }

    // ----------------------------- Accessors ---------------------------------

    /**
     * Accessor for the strategy tag value
     * @return strategy tag value
     */
    public InheritanceStrategy getStrategyValue()
    {
        return strategy;
    }

    /**
     * Accessor for the Join MetaData.
     * @return Returns the joinMetaData.
     */
    public JoinMetaData getJoinMetaData()
    {
        return joinMetaData;
    }

    /**
     * Mutator for the Join MetaData.
     * @param joinMetaData The joinMetaData to set.
     */
    public void setJoinMetaData(JoinMetaData joinMetaData)
    {
        this.joinMetaData = joinMetaData;
        if (this.joinMetaData != null)
        {
            this.joinMetaData.parent = this;
        }
    }

    /**
     * Accessor for the Discrimintor MetaData.
     * @return Returns the Discrimintor MetaData.
     */
    public DiscriminatorMetaData getDiscriminatorMetaData()
    {
        return discriminatorMetaData;
    }

    /**
     * Mutator for the Discriminator MetaData.
     * @param discriminatorMetaData The discriminatorMetaData to set.
     */
    public void setDiscriminatorMetaData(DiscriminatorMetaData discriminatorMetaData)
    {
        this.discriminatorMetaData = discriminatorMetaData;
        this.discriminatorMetaData.parent = this;
    }

    // ----------------------------- Utilities ---------------------------------

    /**
     * Returns a string representation of the object using a prefix
     * @param prefix prefix string
     * @param indent indent string
     * @return a string representation of the object.
     */
    public String toString(String prefix,String indent)
    {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<inheritance strategy=\"" + strategy + "\">\n");

        // Add join
        if (joinMetaData != null)
        {
            sb.append(joinMetaData.toString(prefix + indent,indent));
        }

        // Add discriminator
        if (discriminatorMetaData != null)
        {
            sb.append(discriminatorMetaData.toString(prefix + indent,indent));
        }

        // Add extensions
        sb.append(super.toString(prefix + indent,indent));

        sb.append(prefix).append("</inheritance>\n");

        return sb.toString();
    }
}