/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.metadata;

/**
 * Factory for ClassMetaData, InterfaceMetaData, FieldMetaData and PropertyMetaData objects.
 * @version $Revision: 1.6 $
 */
public interface MetaDataFactory
{
    /**
     * Constructor for an InterfaceMetaData.
     * Takes the basic string information found in the XML/annotations.
     * @param pmd MetaData for the package that this class belongs to
     * @param name Name of class
     * @param identityType Type of identity
     * @param objectidClass Class of the object id
     * @param requiresExtent Whether the class requires an extent
     * @param detachable Whether this is detachable
     * @param embeddedOnly embedded-only tag
     * @param catalog Name for catalog
     * @param schema Name for schema
     * @param table Name of the table where to persist objects of this type
     * @param entityName the entity name required by JPA 4.3.1
     */
    public abstract InterfaceMetaData newInterfaceObject(final PackageMetaData pmd, final String name, 
            final String identityType, final String objectidClass, final String requiresExtent, final String detachable, 
            final String embeddedOnly, 
            final String catalog, final String schema, final String table, final String entityName);

    /**
     * Constructor for a ClassMetaData.
     * Takes the basic string information found in the XML/annotations.
     * @param pmd MetaData for the package that this class belongs to
     * @param name Name of class
     * @param identityType Type of identity
     * @param objectidClass Class of the object id
     * @param requiresExtent Whether the class requires an extent
     * @param detachable Whether this is detachable
     * @param embeddedOnly embedded-only tag
     * @param modifier persistence modifier for the class
     * @param persistenceCapableSuperclass PC superclass (optional)
     * @param catalog Name for catalog
     * @param schema Name for schema
     * @param table Name of the table where to persist objects of this type
     * @param entityName the entity name required by JPA 4.3.1
     */
    public abstract ClassMetaData newClassObject(final PackageMetaData pmd, final String name, 
            final String identityType, final String objectidClass, final String requiresExtent, final String detachable, 
            final String embeddedOnly, final String modifier, final String persistenceCapableSuperclass, 
            final String catalog, final String schema, final String table, final String entityName);

    /**
     * Constructor for a FieldMetaData.
     * @param md MetaData for the class that this field belongs to
     * @param name Name of the field
     * @param pk Whether it is a part of the PK
     * @param modifier persistence-modifier
     * @param defaultFetchGroup Whether it is in the DFG
     * @param nullValue Action on null value inserts
     * @param embedded Whether it is embedded
     * @param serialized Whether it is serialised
     * @param dependent Whether it is dependent for deletes
     * @param mappedBy Field in other class that it is mapped using
     * @param column Column name to store it
     * @param table Table where it is stored
     * @param catalog Catalog that the table is in
     * @param schema Schema that the table is in
     * @param deleteAction Any FK delete action
     * @param indexed Whether it is indexed
     * @param unique Whether it is unique
     * @param recursionDepth Recursion depth to apply on fetch-plan operations
     * @param loadFetchGroup Whether to load the fetch group
     * @param valueStrategy Strategy for generating values for this field
     * @param sequence Sequence name if the strategy is "sequence"
     * @param fieldType Type of the field
     * @return MetaData for the field
     */
    public abstract FieldMetaData newFieldObject(final MetaData md, final String name, final String pk, 
            final String modifier, final String defaultFetchGroup, final String nullValue, final String embedded, 
            final String serialized, final String dependent, final String mappedBy, final String column, 
            final String table, final String catalog, final String schema, 
            final String deleteAction, final String indexed, final String unique, 
            final String recursionDepth, final String loadFetchGroup, 
            final String valueStrategy, final String sequence, final String fieldType);

    /**
     * Constructor for a FieldMetaData copying the supplied FieldMetaData.
     * @param md Parent MetaData
     * @param referenceFmd FieldMetaData to copy.
     * @return The new FieldMetaData
     */
    public abstract FieldMetaData newFieldObject(MetaData md, AbstractMemberMetaData referenceFmd);

    /**
     * Constructor for a PropertyMetaData.
     * @param md MetaData for the interface that this property belongs to
     * @param name Name of the field
     * @param pk Whether it is a part of the PK
     * @param modifier persistence-modifier
     * @param defaultFetchGroup Whether it is in the DFG
     * @param nullValue Action on null value inserts
     * @param embedded Whether it is embedded
     * @param serialized Whether it is serialised
     * @param dependent Whether it is dependent for deletes
     * @param mappedBy Field in other class that it is mapped using
     * @param column Column name to store it
     * @param table Table where it is stored
     * @param catalog Catalog that the table is in
     * @param schema Schema that the table is in
     * @param deleteAction Any FK delete action
     * @param indexed Whether it is indexed
     * @param unique Whether it is unique
     * @param recursionDepth Recursion depth to apply on fetch-plan operations
     * @param loadFetchGroup Whether to load the fetch group
     * @param valueStrategy Strategy for generating values for this field
     * @param sequence Sequence name if the strategy is "sequence"
     * @param fieldType Type of the field
     * @param fieldName Name of the field (relates to the implementation of this)
     * @return MetaData for the field
     */
    public abstract PropertyMetaData newPropertyObject(final MetaData md, final String name, final String pk, 
            final String modifier, final String defaultFetchGroup, final String nullValue, final String embedded, 
            final String serialized, final String dependent, final String mappedBy, final String column, 
            final String table, final String catalog, final String schema,
            final String deleteAction, final String indexed, final String unique, 
            final String recursionDepth, final String loadFetchGroup, 
            final String valueStrategy, final String sequence, final String fieldType, final String fieldName);

    /**
     * Constructor for a PropertyMetaData copying the supplied PropertyMetaData.
     * @param md Parent MetaData
     * @param referencePmd PropertyMetaData to copy.
     * @return The new PropertyMetaData
     */
    public abstract PropertyMetaData newPropertyObject(MetaData md, PropertyMetaData referencePmd);
}