/******************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
*****************************************************************/
package org.datanucleus.metadata.xml;

import org.datanucleus.util.AbstractXMLEntityResolver;

/**
 * Implementation of an entity resolver for "persistence.xml" files.
 * Handles entity resolution using XSD only.
 */
public class PersistenceEntityResolver extends AbstractXMLEntityResolver
{
    public PersistenceEntityResolver()
    {
        // Add definitions for internally supported URLs
        systemIdEntities.put("http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd", "/org/datanucleus/jpa/jpa_persistence_1_0.xsd");
    }
}