/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query;

/**
 * JDOQL query helper class providing key information about the language etc.
 */
public class JDOQLQueryHelper
{
    /** Keywords used in single-string JDOQL. Uppercase variants specified here, but we allow the lowercase form. */
    public static final String[] SINGLE_STRING_KEYWORDS = {
            "SELECT", "UNIQUE", "INTO", "FROM", "EXCLUDE", "SUBCLASSES", "WHERE",
            "VARIABLES", "PARAMETERS", "GROUP", "ORDER", "BY", "RANGE"
            };
    /** Keywords in lowercase (we avoid calling toLowerCase() multiple times, which is expensive operation) **/
    public static final String[] SINGLE_STRING_KEYWORDS_LOWERCASE = {
            "select", "unique", "into", "from", "exclude", "subclasses", "where",
            "variables", "parameters", "group", "order", "by", "range"
            };

    /**
     * Convenience method returning if the supplied name is a keyword for this query language.
     * @param name Name to check
     * @return Whether it is a keyword
     */
    public static boolean isKeyword(String name)
    {
        for (int i=0;i<SINGLE_STRING_KEYWORDS.length;i++)
        {
            // JDOQL is case-sensitive - lowercase or UPPERCASE only
            if (name.equals(SINGLE_STRING_KEYWORDS[i]) || 
                name.equals(SINGLE_STRING_KEYWORDS_LOWERCASE[i]))
            {
                return true;
            }
        }
        if (name.equals("IMPORT") || name.equals("import"))
        {
            return true;
        }
        return false;
    }
}