/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.compiler;

import org.datanucleus.query.node.Node;

/**
 * Interface for a parser of a query.
 * To be implemented for each particular query language.
 * Responsible for taking a String clause of a query and converting it into a Node tree.
 */
public interface Parser
{
    public abstract Node compile(String expression);

    public abstract Node[] compileFrom(String expression);

    public abstract Node[] compileOrder(String expression);

    public abstract Node[] compileTupple(String expression);

    public abstract Node[][] compileVariables(String expression);

    public abstract Node compileVariable(String expression);

    public abstract Node[][] compileParameters(String expression);
}