/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2008 Andy Jefferson - restructured to take in applyXXX flags and evaluate different parts if required
    ...
**********************************************************************/
package org.datanucleus.query.evaluator;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.memory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.Query;

/**
 * Class to evaluate a JDOQL query in whole or part.
 */
public class JDOQLEvaluator extends JavaQueryEvaluator
{
    /**
     * Constructor.
     * @param query The underlying JDOQL query
     * @param inputList List of objects as input to the evaluation process
     * @param compilation Query compilation
     * @param parameterValues Input params
     * @param clr ClassLoader resolver
     */
    public JDOQLEvaluator(Query query, List inputList, QueryCompilation compilation, Map parameterValues,
            ClassLoaderResolver clr)
    {
        super("JDOQL");
        this.query = query;
        this.clr = clr;
        this.filter = compilation.getExprFilter();
        this.having = compilation.getExprHaving();
        this.ordering = compilation.getExprOrdering();
        this.grouping = compilation.getExprGrouping();
        this.result = compilation.getExprResult();
        this.symtbl = compilation.getSymbolTable();
        this.parameterValues = parameterValues;
        this.sourceObjects = inputList;
        this.candidateAlias = compilation.getCandidateAlias();
        evaluator = new InMemoryExpressionEvaluator(query.getObjectManager().getOMFContext().getQueryManager(),
            symtbl, query.getParsedImports(), clr, candidateAlias);
    }

    /**
     * Constructs ResultClassMapper and calls its map function
     * @param resultSet The resultSet containing the instances handeld by setResult
     * @return The resultSet containing instances of the Class defined by setResultClass
     */
    Collection mapResultClass(Collection resultSet)
    {
        return new JDOQLResultClassMapper(query.getResultClass()).map(resultSet, result);
    }
}