/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.expression;

import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

/**
 * Expression representing a join between a candidate class, and the class of a field of the first class.
 * An example is in JPQL where we have a "from" clause like
 * <pre>SELECT ... FROM Product p JOIN p.reviews r</pre>
 * so the join between "Product p" and "Review r" using "p.reviews".
 * Can have a JoinExpression to its right.
 */
public class JoinExpression extends Expression
{
    public static final int JOIN_INNER = 0;
    public static final int JOIN_OUTER = 1;
    public static final int JOIN_INNER_FETCH = 2;
    public static final int JOIN_OUTER_FETCH = 3;

    String alias;
    int type;
    PrimaryExpression primExpr; // Expression for the field we are joining to

    SymbolTable symtbl;

    public JoinExpression(SymbolTable symtbl, PrimaryExpression expr, String alias, int type)
    {
        this.symtbl = symtbl;
        this.primExpr = expr;
        this.alias = alias;
        this.type = type;
    }

    public Object evaluate(ExpressionEvaluator eval)
    {
        return eval.evaluate(this);
    }

    public void setJoinExpression(JoinExpression expr)
    {
        this.right = expr;
    }

    public PrimaryExpression getPrimaryExpression()
    {
        return primExpr;
    }

    public String getAlias()
    {
        return alias;
    }

    public int getType()
    {
        return type;
    }

    public Symbol bind()
    {
        // TODO Implement this
        return null;
    }
}