/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.expression;

import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

/**
 * Expression representing an implicit parameter.
 * Explicit parameters will be represented as a PrimaryExpression.
 * TODO Represent explicit parameters using this expression type.
 */
public class ParameterExpression extends Expression
{
    SymbolTable symtbl;
    String name;
    int position; // Position in the query (when name not specified in execution parameters)
    
    public ParameterExpression(SymbolTable symtbl, String name, int position)
    {
        this.symtbl = symtbl;
        this.name = name;
        this.position = position;
    }
    
    public Object evaluate(ExpressionEvaluator eval)
    {
        return eval.evaluate(this);
    }

    public String getId()
    {
        return name;
    }

    public int getPosition()
    {
        return position;
    }

    public Symbol bind()
    {
        if (symtbl.hasSymbol(getId()))
        {
            symbol = symtbl.getSymbol(getId());
        }
        else
        {
            // No symbol for this parameter yet, so add one - type not known
            symbol = new PropertySymbol(getId());
            symtbl.addSymbol(symbol);
        }
        return symbol;
    }

    public String toString()
    {
        return "ParameterExpression: " + name;
    }
}