/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.expression;

import java.util.List;

import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;

public class VariableExpression extends Expression
{
    SymbolTable symtbl;
    List tuples;
    List parameters;
    
    public VariableExpression(SymbolTable symtbl, List tuples, List parameters)
    {
        this.symtbl = symtbl;
        this.tuples = tuples;
        this.parameters = parameters;
    }
    
    public Object evaluate(ExpressionEvaluator eval)
    {
        return eval.evaluate(this);
    }
    
    /**
     * Accessor for the id of the variable.
     * @return The id of the variable
     */
    public String getId()
    {
        StringBuffer id = new StringBuffer();
        
        for (int i = 0; i < tuples.size() - 1; i++)
        {
            if (id.length() > 0)
            {
                id.append('.');
            }
            id.append((String) tuples.get(i));
        }
        return id.toString();
    }
    
    /**
     * Accessor for the operation.
     * @return The operation
     */
    public String getOperation()
    {
        return (String)tuples.get(tuples.size()-1);
    }

    public List getTuples()
    {
        return tuples;
    }
    
    public Symbol bind()
    {
        if (symtbl.hasSymbol(getId()))
        {
            symbol = symtbl.getSymbol(getId());
        }
        else
        {
            symbol = new PropertySymbol(getId(), symtbl.getType(tuples.subList(0, tuples.size() - 1)));
        }
        return symbol;
    }
    
    public List getParameters()
    {
        return parameters;
    }
}