/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.symbol;

import org.datanucleus.util.StringUtils;

/**
 * Symbol representing a property/identifier in a query. 
 * This can be an identifier, or a parameter for example.
 * Alternatively can be a special case such as a candidate class, or a set of candidates.
 */
public class PropertySymbol implements Symbol
{
    int type;

    final String qualifiedName;

    Class valueType;
    Object value;

    public PropertySymbol(String qualifiedName)
    {
        this.qualifiedName = qualifiedName;
    }

    public PropertySymbol(String qualifiedName, Class type)
    {
        this.qualifiedName = qualifiedName;
        this.valueType = type;
    }

    public void setType(int type)
    {
        this.type = type;
    }

    public int getType()
    {
        return type;
    }

    public String getQualifiedName()
    {
        return qualifiedName;
    }

    public Class getValueType()
    {
        return valueType;
    }
    
    public Object getValue()
    {
        return value;
    }
    
    public void setValue(Object value)
    {
        this.value = value;
    }
    
    public void setValueType(Class type)
    {
        this.valueType = type;
    }
    
    public String toString()
    {
        String typeName = null;
        if (type == IDENTIFIER)
        {
            typeName = "IDENTIFIER";
        }
        else if (type == PARAMETER)
        {
            typeName = "PARAMETER";
        }
        else if (type == VARIABLE)
        {
            typeName = "VARIABLE";
        }
        else if (type == CANDIDATES)
        {
            typeName = "CANDIDATES";
        }
        return "Symbol: " + qualifiedName + " [valueType=" + valueType +
            ", type=" + typeName + 
            ", value=" + StringUtils.toJVMIDString(value) + "]";
    }
}