/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.symbol;

public interface Symbol
{
    public static final int IDENTIFIER = 0;
    public static final int PARAMETER = 1;
    public static final int VARIABLE = 2;
    public static final int CANDIDATES = 3;

    /** Name under which any set of results are stored in the SymbolTable. Used for aggregation. */
    public static final String RESULTS_SET = "DATANUCLEUS_RESULTS_SET";

    void setType(int type);
    int getType();

    String getQualifiedName();

    void setValueType(Class type);
    Class getValueType();

    void setValue(Object value);
    Object getValue();
}