/**********************************************************************
Copyright (c) 2008 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.query.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;

public class SymbolTable
{
    Map symbols = new HashMap();
    List symbolsTable = new ArrayList();

    ClassLoaderResolver clr;

    SymbolResolver resolver;

    public SymbolTable(ClassLoaderResolver clr)
    {
        this.clr = clr;
    }

    public ClassLoaderResolver getClassLoaderResolver()
    {
        return clr;
    }

    Symbol getSymbol(int index)
    {
        synchronized (symbolsTable)
        {
            return (Symbol) symbolsTable.get(index);
        }
    }
    
    public void setSymbolResolver(SymbolResolver resolver)
    {
        this.resolver = resolver;
    }

    public Symbol getSymbol(String name)
    {
        synchronized (symbolsTable)
        {
            return (Symbol) symbols.get(name);
        }
    }    
    
    public boolean hasSymbol(String name)
    {
        synchronized (symbolsTable)
        {
            return symbols.containsKey(name);
        }
    }    
    
    public int addSymbol(Symbol symbol)
    {
        synchronized (symbolsTable)
        {
            if (symbols.containsKey(symbol.getQualifiedName()))
            {
                throw new NucleusException("Symbol "+symbol.getQualifiedName()+" already exists.");
            }
            symbols.put(symbol.getQualifiedName(), symbol);
            symbolsTable.add(symbol);
            return symbolsTable.size();
        }
    }
    
    public String toString()
    {
        return symbols.toString();
    }
    
    public Class getType(List tuples)
    {
        return resolver.getType(tuples);
    }
}