/**********************************************************************
Copyright (c) 2005 Erik Bengtson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.sco.simple;

import org.datanucleus.StateManager;

/**
 * A mutable second-class BitSet object.
 */
public class BitSetJDK14 extends BitSet
{
    /**
     * Creates a <tt>BitSet</tt> object. Assigns owning object and field name.
     * @param ownerSM the owning object
     * @param fieldName the owning field name
     */
    public BitSetJDK14(StateManager ownerSM, String fieldName)
    {
        super(ownerSM, fieldName);
    }

    //  ------------------------- BitSet Methods -----------------------------

    /* (non-Javadoc)
     * @see java.util.BitSet#clear()
     */
    public void clear()
    {
        super.clear();
        makeDirty();
    }

    /* (non-Javadoc)
     * @see java.util.BitSet#clear(int, int)
     */
    public void clear(int fromIndex, int toIndex)
    {
        super.clear(fromIndex, toIndex);
        makeDirty();
    }

    /* (non-Javadoc)
     * @see java.util.BitSet#flip(int, int)
     */
    public void flip(int fromIndex, int toIndex)
    {
        super.flip(fromIndex, toIndex);
        makeDirty();
    }

    /* (non-Javadoc)
     * @see java.util.BitSet#flip(int)
     */
    public void flip(int bitIndex)
    {
        super.flip(bitIndex);
        makeDirty();
    }    
    
    /* (non-Javadoc)
     * @see java.util.BitSet#set(int, boolean)
     */
    public void set(int bitIndex, boolean value)
    {
        super.set(bitIndex, value);
        makeDirty();
    }

    /* (non-Javadoc)
     * @see java.util.BitSet#set(int, int, boolean)
     */
    public void set(int fromIndex, int toIndex, boolean value)
    {
        super.set(fromIndex, toIndex, value);
        makeDirty();
    }

    /* (non-Javadoc)
     * @see java.util.BitSet#set(int, int)
     */
    public void set(int fromIndex, int toIndex)
    {
        super.set(fromIndex, toIndex);
        makeDirty();
    }
}