/**********************************************************************
Copyright (c) 2005 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.sco.simple;

import org.datanucleus.StateManager;

/**
 * A mutable second-class GregorianCalendar object.
 *
 * @version $Revision: 1.4 $
 */
public class GregorianCalendarJDK14 extends GregorianCalendar
{
    /**
     * Creates a <tt>GregorianCalendar</tt> object that represents the time at which
     * it was allocated. Assigns owning object and field name.
     *
     * @param ownerSM the owning object
     * @param fieldName the owning field name
     */
    public GregorianCalendarJDK14(StateManager ownerSM, String fieldName)
    {
        super(ownerSM, fieldName);
    }

    /**
     * Method to set a field
     * @param field The field
     * @param value The new value
     */
    public void set(int field, int value)
    {
        super.set(field, value);
        makeDirty();
    }
}