/**********************************************************************
Copyright (c) 2005 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 


Contributors:
    ...
**********************************************************************/
package org.datanucleus.state;

import java.util.HashMap;
import java.util.Map;

import org.datanucleus.api.ApiAdapter;
import org.datanucleus.util.StringUtils;

/**
 * Holder for the detachment state control for the detachment process.
 * 
 * @version $Revision: 1.3 $
 */
public class DetachState extends FetchPlanState
{
    /** a map for the current execution of detachCopy with detached objects keyed by the object id **/
    private Map detachedObjectById = new HashMap();

    /** Adapter for the API being used. */
    private ApiAdapter api;

    /**
     * Constructor.
     * @param api The API adapter
     */
    public DetachState(ApiAdapter api)
    {
        this.api = api;
    }

    /**
     * Set to the current state a detached copy object
     * @param detachedPC the Detached persistable object
     * @param id The id to key against. If this is null, we treat as embedded
     */
    public void setDetachedCopyObject(Object detachedPC, Object id)
    {
        if (id == null)
        {
            // embedded element (NO ids)
            detachedObjectById.put(StringUtils.toJVMIDString(detachedPC), detachedPC);
        }
        else
        {
            detachedObjectById.put(id, detachedPC);
        }
    }

    /**
     * Set to the current state a detached copy object
     * @param pc the PersistenceCapable of the object searched
     * @return the Detached PC
     */
    public Object getDetachedCopyObject(Object pc)
    {
        Object id = api.getIdForObject(pc);
        if (id == null)
        {
            // embedded element (NO ids)
            return detachedObjectById.get(StringUtils.toJVMIDString(pc));
        }
        else
        {
            return detachedObjectById.get(id);
        }
    }
}