/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
2003 Andy Jefferson - introduction of localiser
2004 Andy Jefferson - moved to org.datanucleus.store
2006 Andy Jefferson - generalised so that can be used for any store
    ...
**********************************************************************/
package org.datanucleus.store;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.util.ClassUtils;

/**
 * Factory for creating StoreManagers.
 *
 * @version $Revision: 1.13 $ 
 **/
public class StoreManagerFactory
{
    /**
     * Default Constructor.
     **/
    private StoreManagerFactory()
    {
        // protects this class from been instantiated
    }

    /**
     * Accessor for the StoreManager. Creates an instance of StoreManager if necessary
     * @param managerClassName Name of the class name for the Store Manager
     * @param clr the ClassLoaderResolver
     * @param omf Object Manager Factory
     * @return The Store Manager.
     **/
    public static synchronized StoreManager getStoreManager(String managerClassName,
            ClassLoaderResolver clr, ObjectManagerFactoryImpl omf)
    {
        // Create a new StoreManager of this type
        // TODO Cache the StoreManagers
        Class managerCls = clr.classForName(managerClassName, ObjectManagerFactoryImpl.class.getClassLoader());
        Class[] ctrArgTypes = new Class[] {ClassLoaderResolver.class, ObjectManagerFactoryImpl.class};
        Object[] ctrArgs = new Object[] {clr, omf};
        return (StoreManager)ClassUtils.newInstance(managerCls, ctrArgTypes, ctrArgs);
    }
}