/**********************************************************************
Copyright (c) 2006 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2006 Alexander Bieber - Initial proposal and design
    ...
**********************************************************************/
package org.datanucleus.store.query;

import java.io.Serializable;

/**
 * Metadata for query results.
 * Can be for JDOQL, JPQL, or some other language in principle.
 */
public class QueryResultsMetaData implements Serializable
{
    /** type of all expressions in the result **/
    final Class[] types;

    /**
     * Constructor.
     * @param types type of all expressions in the result 
     */
    public QueryResultsMetaData(Class[] types)
    {
        this.types = types;
    }

    /**
     * The number of expressions in the result
     * @return The number of expressions returned by the associated query.
     */
    public int getExpressionCount()
    {
        return types.length;
    }

    /**
    * Returns the Java class of the expression referenced by the given index that
    * is returned by the associated query.
    * @param exprIndex The 0-based index of the expression the type should be returned for.
    * @return The Java class of the expression with the given index.
    * @throws IndexOutOfBoundsException if the index is out of range 
    */
    public Class getExpressionType(int exprIndex)
    {
        if (exprIndex < 0 || exprIndex >= types.length)
        {
            // TODO Localise this message
            throw new IndexOutOfBoundsException("Number of expressions in result set is " +
                types.length + ". You tried to access index " + exprIndex);
        }
        return types[exprIndex];
    }
}