/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store;

import java.util.Iterator;

import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;

/**
 * Extent of objects within DataNucleus.
 * Represents objects of a type, optionally including the subclasses of that type.
 */
public interface Extent
{
    Class getCandidateClass();

    boolean hasSubclasses();

    ObjectManager getObjectManager();

    FetchPlan getFetchPlan();

    Iterator iterator();

    void closeAll();

    void close(Iterator iterator);
}