/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2002 Mike Martin (TJDO)
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

/**
 * Mapping for the Short type.
 */
public class ShortMapping extends SingleFieldMapping
{
    public Class getJavaType()
    {
        return Short.class;
    }

    // TODO Delete when we drop legacy support
    private static Short mappingSampleValue = Short.valueOf((short)0);
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return mappingSampleValue;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        return new IntegerLiteral(qs, this, (Number)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te)
    {
        return new NumericExpression(qs, this, te);
    }
}