/**********************************************************************
Copyright (c) 2009 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.state;

import java.util.Set;

import javax.jdo.spi.PersistenceCapable;

import org.datanucleus.FetchPlan;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.StringUtils;

/**
 * Implementation of ObjectProvider for StateManager 
 */
public class ObjectProviderImpl implements ObjectProvider
{
    StateManager sm;

    public ObjectProviderImpl(StateManager sm)
    {
        this.sm = sm;
    }
    
    public StateManager getStateManager()
    {
        return sm;
    }

    public AbstractClassMetaData getClassMetaData()
    {
        return sm.getClassMetaData();
    }
    
    public Object provideField(int fieldNumber)
    {
        return sm.provideField(fieldNumber);
    }

    public void provideFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.provideFields(fieldNumbers, fm);
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.replaceFields(fieldNumbers, fm);
    }

    public void replaceField(int fieldNumber, Object value)
    {
        sm.replaceField(fieldNumber, value, false);
    }
    
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm)
    {
        sm.replaceNonLoadedFields(fieldNumbers, fm);
    }
    
    public String toPrintableID()
    {
        return StringUtils.toJVMIDString(sm.getObject());
    }
    
    public Object wrapSCOField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged)
    {
        return sm.wrapSCOField(fieldNumber, value, forInsert, forUpdate, replaceFieldIfChanged);
    }
    
    public Object getObject()
    {
        return sm.getObject();
    }
    
    public Object getInternalObjectId()
    {
        return sm.getInternalObjectId();
    }
    
    public Object getExternalObjectId()
    {
        return sm.getExternalObjectId(sm.getObject());
    }
    public String[] getDirtyFieldNames()
    {
        return sm.getDirtyFieldNames();
    }

    public int[] getDirtyFieldNumbers()
    {
        return sm.getDirtyFieldNumbers();
    }
    
    public ObjectProvider[] getEmbeddedOwners()
    {
        StateManager[] sms = sm.getEmbeddedOwners();
        if (sms==null)
        {
            return null;
        }
        ObjectProvider op[] = new ObjectProvider[sms.length];
        for (int i=0; i<sms.length; i++)
        {
            op[i] = sms[i].getObjectProvider();
        }
        return op;
    }
    
    public boolean isInserting()
    {
        return sm.isInserting();
    }
    
    public void loadUnloadedFields()
    {
        sm.loadUnloadedFields();
    }
    public void makeDirty(int fieldNumber)
    {
        sm.makeDirty(fieldNumber);
    }
    
    public void setAssociatedValue(Object key, Object value)
    {
        sm.setAssociatedValue(key, value);
    }
    
    public LifeCycleState getLifecycleState()
    {
        return ((AbstractStateManager)sm).getLifecycleState();
    }
    
    /**
     * Method to register an owner StateManager with this embedded/serialised object.
     * @param ownerSM The owning State Manager.
     * @param ownerFieldNumber The field number in the owner that the embedded/serialised object is stored as
     */
    public void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber)
    {
        sm.addEmbeddedOwner(ownerSM==null?null:((ObjectProviderImpl)ownerSM).getStateManager(), ownerFieldNumber);
    }
    
    public boolean isEmbedded()
    {
        return sm.isEmbedded();
    }
    
    public void copyFieldsFromObject(Object pc, int[] fieldNumbers)
    {
       sm.copyFieldsFromObject((PersistenceCapable)pc, fieldNumbers);
        
    }
    public Object getTransactionalVersion()
    {
        return sm.getTransactionalVersion(sm.getObject());
    }
    public ExecutionContext getExecutionContext()
    {
        return sm.getObjectManager().getExecutionContext();
    }
    public Object unwrapSCOField(int fieldNumber, Object value, boolean replaceFieldIfChanged)
    {
        return sm.unwrapSCOField(fieldNumber, value, replaceFieldIfChanged);
    }
    public void replaceFieldMakeDirty(int fieldNumber, Object value)
    {
        sm.replaceField(fieldNumber, value, true);
    }
    public boolean[] getLoadedFields()
    {
        return sm.getLoadedFields();
    }
    public void runReachability(Set reachables)
    {
        sm.runReachability(reachables);
    }

    public void setPcObjectType(short embeddedType)
    {
        sm.setPcObjectType(embeddedType);
    }
    public short getPcObjectType()
    {
        return sm.getPcObjectType();
    }

    public void setStoringPC()
    {
        sm.setStoringPC();
    }
    public void flush()
    {
        sm.flush();
    }
    public boolean isWaitingToBeFlushedToDatastore()
    {
        return sm.isWaitingToBeFlushedToDatastore();
    }
    public boolean isDeleting()
    {
        return sm.isDeleting();
    }
    public void loadFieldValues(final FieldValues2 fieldValues)
    {
        sm.loadFieldValues(new FieldValues()
        {
            
            public FetchPlan getFetchPlanForLoading()
            {
                return fieldValues.getFetchPlanForLoading();
            }
            
            public void fetchNonLoadedFields(StateManager sm)
            {
                fieldValues.fetchNonLoadedFields(sm.getObjectProvider());
            }
            
            public void fetchFields(StateManager sm)
            {
                fieldValues.fetchFields(sm.getObjectProvider());
            }
        });
    }
    public RelationshipManager getRelationshipManager()
    {
        return sm.getRelationshipManager();
    }
    public Object getReferencedPC()
    {
        return sm.getReferencedPC();
    }
    public void unsetStoringPC()
    {
        sm.unsetStoringPC();
    }
    public void setObjectField(Object pc, int fieldNumber, Object oldValue, Object newValue)
    {
        sm.setObjectField((PersistenceCapable) pc, fieldNumber, oldValue, newValue);
    }
    public void loadField(int fieldNumber)
    {
        sm.loadField(fieldNumber);
    }
    public boolean isLoaded(Object pc, int fieldNumber)
    {
        return sm.isLoaded((PersistenceCapable) pc, fieldNumber);
    }
    public void setTransactionalVersion(Object optimisticTransactionalVersion)
    {
        sm.setTransactionalVersion(optimisticTransactionalVersion);
    }
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty)
    {
        sm.replaceFields(fieldNumbers, fm, replaceWhenDirty);
    }
    public void setVersion(Object version)
    {
        sm.setVersion(version);
    }
    public int[] getLoadedFieldNumbers()
    {
        return sm.getLoadedFieldNumbers();
    }
    public void updateFieldAfterInsert(Object pc, int fieldNumber)
    {
        sm.updateFieldAfterInsert(pc, fieldNumber);
    }
    public void setPostStoreNewObjectId(Object id)
    {
        sm.setPostStoreNewObjectId(id);
    }
    public void changeActivityState(ActivityState inserting)
    {
        sm.changeActivityState(inserting);
    }
    public Object getAssociatedValue(JavaTypeMapping mapping)
    {
        return sm.getAssociatedValue(mapping);
    }
    public boolean becomingDeleted()
    {
        return sm.becomingDeleted();
    }
    public void loadFieldsInFetchPlan(FetchPlanState state)
    {
        sm.loadFieldsInFetchPlan(state);
    }
    public void loadFieldFromDatastore(int fieldNumber)
    {
        sm.loadFieldFromDatastore(fieldNumber);
    }
    public Object getObjectId()
    {
        return sm.getObjectId((PersistenceCapable) sm.getObject());
    }
    public Object getVersion()
    {
        return sm.getVersion((PersistenceCapable) sm.getObject());
    }

    public void unloadField(String name)
    {
        sm.unloadField(name);
    }

    public void replaceAllLoadedSCOFieldsWithWrappers()
    {
        sm.replaceAllLoadedSCOFieldsWithWrappers();
    }

    public void replaceAllLoadedSCOFieldsWithValues()
    {
        sm.replaceAllLoadedSCOFieldsWithValues();
    }

    public boolean getAllFieldsLoaded()
    {
        return sm.getAllFieldsLoaded();
    }

    public void replaceManagedPC(Object pc2)
    {
        // TODO Auto-generated method stub
        sm.replaceManagedPC((PersistenceCapable) pc2);
    }

    public String[] getLoadedFieldNames()
    {
        return sm.getLoadedFieldNames();
    }
}