/**********************************************************************
Copyright (c) 2009 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;

import org.datanucleus.OMFContext;
import org.datanucleus.util.StringUtils;

/**
 * Abstract implementation of a ConnectionFactory for a DataNucleus supported datastore.
 */
public abstract class AbstractConnectionFactory implements ConnectionFactory
{
    /** The underlying ObjectManagerFactory context. */
    protected OMFContext omfContext;

    protected Map options = new HashMap();

    protected String resourceType;

    /**
     * Constructor.
     * @param omfContext The OMF context
     * @param resourceType Type of resource (tx, nontx)
     */
    public AbstractConnectionFactory(OMFContext omfContext, String resourceType)
    {
        this.omfContext = omfContext;
        this.resourceType = resourceType;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.connection.ConnectionFactory#getConnection(org.datanucleus.ObjectManager, java.util.Map)
     */
    public ManagedConnection getConnection(Object poolKey, org.datanucleus.Transaction transaction, Map options)
    {
        Map addedOptions = new HashMap();
        if (options != null)
        {
            addedOptions.putAll(options);
        }
        addedOptions.putAll(this.options);
        ManagedConnection mconn = omfContext.getStoreManager().getConnectionManager().allocateConnection(this, poolKey, 
            transaction, addedOptions);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    /**
     * Method to return a string form of this object for convenience debug.
     * @return The String form
     */
    public String toString()
    {
        return "ConnectionFactory:" + resourceType + "[" + StringUtils.toJVMIDString(this) + "]";
    }
}