/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.java.MapMapping;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.types.SCOUtils;

public class OracleMapMapping
extends MapMapping {
    @Override
    public void postInsert(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            Map value = (Map)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value != null) {
                ExecutionContext ec = ownerOP.getExecutionContext();
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            byte[] bytes = new byte[]{};
            if (value != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    bytes = baos.toByteArray();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            OracleBlobRDBMSMapping.updateBlobColumn(ownerOP, this.getTable(), this.getDatastoreMapping(0), bytes);
        } else {
            super.postInsert(ownerOP);
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            Map value = (Map)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            if (value != null) {
                ExecutionContext ec = ownerOP.getExecutionContext();
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            this.postInsert(ownerOP);
        } else {
            super.postUpdate(ownerOP);
        }
    }
}

