/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.fieldmanager.ResultSetGetter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.AbstractROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.ConcurrentReferenceHashMap;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class PersistentClassROF<T>
extends AbstractROF<T> {
    protected final AbstractClassMetaData rootCmd;
    protected Class<T> persistentClass;
    protected StatementClassMapping resultMapping = null;
    protected ResultSetGetter resultSetGetter = null;
    private Map resolvedClasses = new ConcurrentReferenceHashMap(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public PersistentClassROF(ExecutionContext ec, ResultSet rs, boolean ignoreCache, FetchPlan fp, StatementClassMapping resultMapping, AbstractClassMetaData acmd, Class<T> persistentClass) {
        super(ec, rs, ignoreCache, fp);
        this.resultMapping = resultMapping;
        this.rootCmd = acmd;
        this.persistentClass = persistentClass;
    }

    @Override
    public ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public T getObject() {
        int[] mappedFieldNumbers;
        StatementClassMapping mappingDefinition;
        AbstractClassMetaData cmd;
        Object[] subclasses;
        String[] subclasses2;
        String className = null;
        boolean requiresInheritanceCheck = true;
        String discrimValue = null;
        boolean hasDiscrimValue = false;
        boolean foundClassByDiscrim = false;
        StatementMappingIndex discrimMapIdx = this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.DISCRIMINATOR.getFieldNumber());
        if (discrimMapIdx != null) {
            try {
                discrimValue = this.rs.getString(discrimMapIdx.getColumnPositions()[0]);
                if (discrimValue == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of discriminator is null so assuming object is null");
                    return null;
                }
                hasDiscrimValue = true;
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getTable().getDiscriminatorMetaData() : null;
                className = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discrimValue, dismd);
                if (className != null) {
                    foundClassByDiscrim = true;
                }
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception obtaining value of discriminator : " + sqle.getMessage()));
            }
        } else if (this.resultMapping.getNucleusTypeColumnName() != null) {
            try {
                className = this.rs.getString(this.resultMapping.getNucleusTypeColumnName());
                if (className == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of determiner column is null so assuming object is null");
                    return null;
                }
                className = className.trim();
                requiresInheritanceCheck = false;
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
        }
        if (requiresInheritanceCheck && ((subclasses2 = this.ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) == null || subclasses2.length == 0)) {
            requiresInheritanceCheck = false;
        }
        String warnMsg = null;
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = this.ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            Class concreteSubclass = null;
            int numConcreteSubclasses = 0;
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                ++numConcreteSubclasses;
                concreteSubclass = subcls;
            }
            if (numConcreteSubclasses == 1) {
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)Localiser.msg((String)"052300", (Object[])new Object[]{pcClassForObject.getName(), concreteSubclass.getName()}));
                pcClassForObject = concreteSubclass;
            } else {
                if (numConcreteSubclasses == 0) {
                    throw new NucleusUserException(Localiser.msg((String)"052301", (Object[])new Object[]{pcClassForObject.getName()}));
                }
                String warnMsgSuffix = hasDiscrimValue && !foundClassByDiscrim ? "No persistent class could be found that matches the discriminator value '" + discrimValue + "'. Has the metadata for all persistent concrete subclasses been added?" : "Really you need a discriminator to help identifying the type.";
                warnMsg = "Found type=" + pcClassForObject + " but abstract and more than 1 concrete subclass (" + StringUtils.objectArrayToString((Object[])subclasses) + ") when searching immediate subclasses. Choosing " + concreteSubclass + ". " + warnMsgSuffix;
                pcClassForObject = concreteSubclass;
                requiresInheritanceCheck = true;
            }
        }
        if ((cmd = this.ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr)) == null) {
            return null;
        }
        int[] fieldNumbers = this.resultMapping.getMemberNumbers();
        if (this.rootCmd instanceof InterfaceMetaData) {
            mappingDefinition = new StatementClassMapping();
            mappingDefinition.setNucleusTypeColumnName(this.resultMapping.getNucleusTypeColumnName());
            mappedFieldNumbers = new int[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                mappingDefinition.addMappingForMember(mappedFieldNumbers[i], this.resultMapping.getMappingForMemberPosition(fieldNumbers[i]));
            }
        } else {
            mappingDefinition = this.resultMapping;
            mappedFieldNumbers = fieldNumbers;
        }
        if (this.resultSetGetter == null) {
            this.resultSetGetter = new ResultSetGetter(this.ec, this.rs, mappingDefinition, this.rootCmd);
        }
        VersionMetaData vermd = cmd.getVersionMetaDataForClass();
        Object surrogateVersion = null;
        StatementMappingIndex versionMapping = null;
        if (vermd != null) {
            if (vermd.getFieldName() == null) {
                versionMapping = this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.VERSION.getFieldNumber());
            } else {
                AbstractMemberMetaData vermmd = cmd.getMetaDataForMember(vermd.getFieldName());
                versionMapping = this.resultMapping.getMappingForMemberPosition(vermmd.getAbsoluteFieldNumber());
            }
        }
        if (versionMapping != null) {
            JavaTypeMapping mapping = versionMapping.getMapping();
            surrogateVersion = mapping.getObject(this.ec, this.rs, versionMapping.getColumnPositions());
        }
        Object obj = null;
        boolean needToSetVersion = false;
        if (this.persistentClass.isInterface() && !cmd.isImplementationOfPersistentDefinition() && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.persistentClass, clr)) == null) {
            cmd = this.ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNumbers = cmd.getPKMemberPositions();
            boolean nullObject = true;
            block8: for (int i = 0; i < pkNumbers.length; ++i) {
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
                if (pkIdx == null) {
                    throw new NucleusException("You have just executed an SQL statement yet the information for the primary key column(s) is not available! Please generate a testcase and report this issue");
                }
                int[] colPositions = pkIdx.getColumnPositions();
                for (int j = 0; j < colPositions.length; ++j) {
                    try {
                        Object pkObj = this.rs.getObject(colPositions[j]);
                        if (pkObj != null) {
                            nullObject = false;
                            continue block8;
                        }
                    }
                    catch (SQLException sqle) {
                        NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception thrown while retrieving results ", (Throwable)sqle);
                    }
                    if (!nullObject) continue block8;
                }
            }
            if (!nullObject) {
                Object id;
                String idClassName;
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if ((idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)(id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)this.ec, (AbstractClassMetaData)cmd, (Class)pcClassForObject, (boolean)requiresInheritanceCheck, (FieldManager)this.resultSetGetter)))) != null) {
                    pcClassForObject = clr.classForName(idClassName);
                }
                obj = this.findObjectWithIdAndLoadFields(id, mappedFieldNumbers, pcClassForObject, cmd, surrogateVersion);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.resultMapping.getMappingForMemberPosition(SurrogateColumnType.DATASTORE_ID.getFieldNumber());
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            Object id = mapping.getObject(this.ec, this.rs, datastoreIdMapping.getColumnPositions());
            if (id != null) {
                String idClassName = IdentityUtils.getTargetClassNameForIdentity((Object)id);
                if (!pcClassForObject.getName().equals(idClassName)) {
                    id = this.ec.getNucleusContext().getIdentityManager().getDatastoreId(pcClassForObject.getName(), IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id));
                }
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                if (mappedFieldNumbers == null) {
                    obj = this.ec.findObject(id, false, requiresInheritanceCheck, null);
                    needToSetVersion = true;
                } else {
                    obj = this.findObjectWithIdAndLoadFields(id, mappedFieldNumbers, requiresInheritanceCheck ? null : pcClassForObject, cmd, surrogateVersion);
                }
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            String classNameForId = className;
            if (className == null) {
                classNameForId = cmd.getFullClassName();
            }
            Object id = this.ec.newObjectId(classNameForId, null);
            if (mappedFieldNumbers == null) {
                obj = this.ec.findObject(id, false, requiresInheritanceCheck, null);
                needToSetVersion = true;
            } else {
                obj = this.findObjectWithIdAndLoadFields(id, fieldNumbers, pcClassForObject, cmd, surrogateVersion);
            }
        }
        if (obj != null && needToSetVersion) {
            ObjectProvider objOP;
            Object verFieldValue;
            int versionFieldNumber;
            if (surrogateVersion != null) {
                ObjectProvider objOP2 = this.ec.findObjectProvider(obj);
                objOP2.setVersion(surrogateVersion);
            } else if (vermd != null && vermd.getFieldName() != null && this.resultMapping.getMappingForMemberPosition(versionFieldNumber = this.rootCmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objOP = this.ec.findObjectProvider(obj)).provideField(versionFieldNumber)) != null) {
                objOP.setVersion(verFieldValue);
            }
        }
        return (T)obj;
    }

    private T findObjectWithIdAndLoadFields(Object id, final int[] fieldNumbers, Class pcClass, final AbstractClassMetaData cmd, final Object surrogateVersion) {
        return (T)this.ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                Object verFieldValue;
                VersionMetaData vermd;
                int versionFieldNumber;
                PersistentClassROF.this.resultSetGetter.setObjectProvider(op);
                op.replaceFields(fieldNumbers, (FieldManager)PersistentClassROF.this.resultSetGetter, false);
                if (surrogateVersion != null) {
                    op.setVersion(surrogateVersion);
                } else if (cmd.getVersionMetaData() != null && cmd.getVersionMetaData().getFieldName() != null && PersistentClassROF.this.resultMapping.getMappingForMemberPosition(versionFieldNumber = PersistentClassROF.this.rootCmd.getMetaDataForMember((vermd = cmd.getVersionMetaData()).getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = op.provideField(versionFieldNumber)) != null) {
                    op.setVersion(verFieldValue);
                }
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                PersistentClassROF.this.resultSetGetter.setObjectProvider(op);
                op.replaceNonLoadedFields(fieldNumbers, (FieldManager)PersistentClassROF.this.resultSetGetter);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fp;
            }
        }, pcClass, this.ignoreCache, false);
    }
}

