/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ComponentInfo;
import org.datanucleus.store.rdbms.scostore.ElementIteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JoinListStore<E>
extends AbstractListStore<E> {
    private String setStmt;

    public JoinListStore(AbstractMemberMetaData mmd, CollectionTable joinTable, ClassLoaderResolver clr) {
        super(joinTable.getStoreManager(), clr);
        this.containerTable = joinTable;
        this.setOwner(mmd);
        if (this.ownerMemberMetaData.getOrderMetaData() != null && !this.ownerMemberMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        this.ownerMapping = joinTable.getOwnerMapping();
        this.elementMapping = joinTable.getElementMapping();
        this.orderMapping = joinTable.getOrderMapping();
        this.relationDiscriminatorMapping = joinTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = joinTable.getRelationDiscriminatorValue();
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = joinTable.isEmbeddedElement();
        this.elementsAreSerialised = joinTable.isSerialisedElement();
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(Localiser.msg((String)"056044", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), joinTable.toString()}));
        }
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, FieldRole.ROLE_COLLECTION_ELEMENT, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ComponentInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ComponentInfo(cmd, table);
                }
            } else {
                this.elementCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.elementCmd != null ? (!this.elementsAreEmbedded ? this.getComponentInformationForClass(this.elementType, this.elementCmd) : null) : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalAdd(ObjectProvider op, int start, boolean atEnd, Collection<E> c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        if (this.relationType == RelationType.MANY_TO_MANY_BI && this.ownerMemberMetaData.getMappedBy() != null) {
            return true;
        }
        int shift = c.size();
        ExecutionContext ec = op.getExecutionContext();
        Iterator<E> iter = c.iterator();
        while (iter.hasNext()) {
            ObjectProvider elementOP;
            E element = iter.next();
            this.validateElementForWriting(ec, element, null);
            if (this.relationType != RelationType.ONE_TO_MANY_BI || (elementOP = ec.findObjectProvider(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementOP.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"056037", (Object[])new Object[]{op.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject())}));
                elementOP.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), op.getObject());
                continue;
            }
            if (elementOwner == op.getObject() || op.getReferencedPC() != null) continue;
            throw new NucleusUserException(Localiser.msg((String)"056038", (Object[])new Object[]{op.getObjectAsPrintable(), this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)elementOP.getObject()), StringUtils.toJVMIDString((Object)elementOwner)}));
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(op) : size;
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager(this.storeMgr, op);
            dynamicSchemaFM.storeObjectField(this.getOwnerMemberMetaData().getAbsoluteFieldNumber(), c);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.invalidateAddStmt();
            }
        }
        String addStmt = this.getAddStmtForJoinTable();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                if (!atEnd && start != currentListSize) {
                    boolean batched = currentListSize - start > 0;
                    for (int i = currentListSize - 1; i >= start; --i) {
                        this.internalShift(op, mconn, batched, i, shift, i == start);
                    }
                } else {
                    start = currentListSize;
                }
                int jdbcPosition = 1;
                boolean batched = c.size() > 1;
                for (E element : c) {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, addStmt, batched);
                    try {
                        jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.orderMapping != null) {
                            jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, start, jdbcPosition, this.orderMapping);
                        }
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        ++start;
                        sqlControl.executeStatementUpdate(ec, mconn, addStmt, ps, !iter.hasNext());
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException | MappedDatastoreException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{addStmt}), (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E set(ObjectProvider op, int index, Object element, boolean allowDependentField) {
        ExecutionContext ec = op.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        E oldElement = null;
        List fieldVal = (List)op.provideField(this.ownerMemberMetaData.getAbsoluteFieldNumber());
        oldElement = fieldVal != null && fieldVal instanceof BackedSCO && ((BackedSCO)fieldVal).isLoaded() ? (E)fieldVal.get(index) : (E)this.get(op, index);
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager(this.storeMgr, op);
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.add(element);
            dynamicSchemaFM.storeObjectField(this.getOwnerMemberMetaData().getAbsoluteFieldNumber(), coll);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.setStmt = null;
            }
        }
        String theSetStmt = this.getSetStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, theSetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    if (this.getOwnerMemberMetaData().getOrderMetaData() != null && !this.getOwnerMemberMetaData().getOrderMetaData().isIndexedList()) {
                        NucleusLogger.PERSISTENCE.warn((Object)"Calling List.addElement at a position for an ordered list is a stupid thing to do; the ordering is set my the ordering specification. Use an indexed list to do this correctly");
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, theSetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056015", (Object[])new Object[]{theSetStmt}), (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && allowDependentField && oldElement != null && !this.contains(op, oldElement)) {
            ec.deleteObjectInternal(oldElement);
        }
        return oldElement;
    }

    @Override
    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(op);
            this.addAll(op, coll, 0);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(op);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.equals(coll)) {
            return;
        }
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean internalRemove(ObjectProvider ownerOP, Object element, int size) {
        boolean modified = false;
        if (this.indexedList) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(element);
            int[] indices = this.getIndicesOf(ownerOP, elements);
            if (indices == null) {
                return false;
            }
            for (int i = 0; i < indices.length; ++i) {
                this.internalRemoveAt(ownerOP, indices[i], size);
                modified = true;
            }
            return modified;
        } else {
            ExecutionContext ec = ownerOP.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                int[] rcs = this.internalRemove(ownerOP, mconn, false, element, true);
                if (rcs == null || rcs[0] <= 0) return modified;
                modified = true;
                return modified;
            }
            catch (MappedDatastoreException sqe) {
                String msg = Localiser.msg((String)"056012", (Object[])new Object[]{sqe.getMessage()});
                NucleusLogger.DATASTORE.error((Object)msg, sqe.getCause());
                throw new NucleusDataStoreException(msg, (Throwable)sqe, ownerOP.getObject());
            }
            finally {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] internalRemove(ObjectProvider op, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt(element);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
            jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
            }
            nArray = sqlControl.executeStatementUpdate(ec, conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new MappedDatastoreException("SQLException", sqle);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        int currentListSize = this.size(op);
        int[] indices = this.getIndicesOf(op, elements);
        if (indices == null) {
            return false;
        }
        boolean modified = false;
        SQLController sqlControl = this.storeMgr.getSQLController();
        ExecutionContext ec = op.getExecutionContext();
        String removeAllStmt = this.getRemoveAllStmt(elements);
        try {
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    int[] number = sqlControl.executeStatementUpdate(ec, mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{removeAllStmt}), (Throwable)e);
        }
        try {
            boolean batched = this.storeMgr.allowsBatching();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                for (int i = 0; i < currentListSize; ++i) {
                    int shift = 0;
                    boolean removed = false;
                    for (int j = 0; j < indices.length; ++j) {
                        if (indices[j] == i) {
                            removed = true;
                            break;
                        }
                        if (indices[j] >= i) continue;
                        ++shift;
                    }
                    if (removed || shift <= 0) continue;
                    this.internalShift(op, mconn, batched, i, -1 * shift, i == currentListSize - 1);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(Localiser.msg((String)"056012", (Object[])new Object[]{removeAllStmt}), (Throwable)e);
        }
        boolean dependent = this.getOwnerMemberMetaData().getCollection().isDependentElement();
        if (this.getOwnerMemberMetaData().isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            op.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    @Override
    protected void internalRemoveAt(ObjectProvider op, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        this.internalRemoveAt(op, index, this.getRemoveAtStmt(), size);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ListIterator<E> listIterator(ObjectProvider ownerOP, int startIdx, int endIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSetStmt() {
        if (this.setStmt == null) {
            JoinListStore joinListStore = this;
            synchronized (joinListStore) {
                StringBuilder stmt = new StringBuilder("UPDATE ").append(this.containerTable.toString()).append(" SET ");
                for (int i = 0; i < this.elementMapping.getNumberOfColumnMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.elementMapping.getColumnMapping(i).getColumn().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(this.elementMapping.getColumnMapping(i).getUpdateInputParameter());
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.getOwnerMemberMetaData().getOrderMetaData() == null || this.getOwnerMemberMetaData().getOrderMetaData().isIndexedList()) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                }
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.setStmt = stmt.toString();
            }
        }
        return this.setStmt;
    }

    protected String getRemoveAllStmt(Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuilder stmt = new StringBuilder("DELETE FROM ").append(this.containerTable.toString()).append(" WHERE ");
        boolean first = true;
        for (Object element : elements) {
            stmt.append(first ? "(" : " OR (");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, false);
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }

    public ElementIteratorStatement getIteratorStatement(ExecutionContext ec, FetchPlan fp, boolean addRestrictionOnOwner, int startIdx, int endIdx) {
        SQLExpression[] orderExprs;
        SelectStatement sqlStmt = null;
        StatementClassMapping elementClsMapping = new StatementClassMapping();
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            sqlStmt = new SelectStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(this.clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            sqlStmt = new SelectStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(this.clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else if (this.elementInfo != null) {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = this.clr.classForName(this.elementInfo[elementNo].getClassName());
                SelectStatement elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    String elementType = this.ownerMemberMetaData.getCollection().getElementType();
                    if (ClassUtils.isReferenceType((Class)this.clr.classForName(elementType))) {
                        String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, this.clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = this.clr.classForName(clsNames[j]);
                        }
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, cls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement(ec);
                    } else {
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement(ec);
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, this.clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                    stmtGen.setOption("selectDnType");
                    elementClsMapping.setNucleusTypeColumnName("DN_TYPE");
                    elementStmt = stmtGen.getStatement(ec);
                }
                if (sqlStmt == null) {
                    sqlStmt = elementStmt;
                    continue;
                }
                sqlStmt.union(elementStmt);
            }
            if (sqlStmt == null) {
                throw new NucleusException("Error in generation of SQL statement for iterator over (Join) list. Statement is null");
            }
            SQLTable elementSqlTbl = sqlStmt.getTable(this.elementInfo[0].getDatastoreClass(), sqlStmt.getPrimaryTable().getGroupName());
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, elementClsMapping, fp, elementSqlTbl, this.elementCmd, fp.getMaxFetchDepth());
        } else {
            throw new NucleusException("Unable to create SQL statement to retrieve elements of List");
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.indexedList) {
            SQLExpression indexVal;
            SQLExpression indexExpr;
            boolean needsOrdering = true;
            if (startIdx == -1 && endIdx == -1) {
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
            } else if (startIdx >= 0 && endIdx == startIdx) {
                needsOrdering = false;
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                sqlStmt.whereAnd(indexExpr.eq(indexVal), true);
            } else {
                if (startIdx >= 0) {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                } else {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                }
                if (endIdx >= 0) {
                    SQLExpression indexExpr2 = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    SQLExpression indexVal2 = exprFactory.newLiteral(sqlStmt, this.orderMapping, endIdx);
                    sqlStmt.whereAnd(indexExpr2.lt(indexVal2), true);
                }
            }
            if (needsOrdering) {
                SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                orderExprs = new SQLExpression[this.orderMapping.getNumberOfColumnMappings()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfColumnMappings()];
                orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
                sqlStmt.setOrdering(orderExprs, descendingOrder);
            }
        } else if (this.elementInfo != null) {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            orderExprs = new SQLExpression[orderComponents.length];
            boolean[] orderDirs = new boolean[orderComponents.length];
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getMemberMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                orderDirs[i] = !orderComponents[i].isForward();
                SQLTable fieldSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), fieldMapping);
                orderExprs[i] = exprFactory.newExpression(sqlStmt, fieldSqlTbl, fieldMapping);
            }
            sqlStmt.setOrdering(orderExprs, orderDirs);
        }
        return new ElementIteratorStatement(this, sqlStmt, elementClsMapping);
    }
}

