/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;

public class MapLiteral
extends MapExpression
implements SQLLiteral {
    private final Map value;
    private final MapValueLiteral mapValueLiteral;
    private final MapKeyLiteral mapKeyLiteral;

    public MapLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
            this.mapKeyLiteral = null;
            this.mapValueLiteral = null;
        } else if (value instanceof Map) {
            Map mapValue;
            this.value = mapValue = (Map)value;
            if (parameterName != null) {
                this.mapKeyLiteral = null;
                this.mapValueLiteral = null;
                this.st.appendParameter(parameterName, mapping, this.value);
            } else {
                this.mapValueLiteral = new MapValueLiteral(stmt, mapping, value);
                this.mapKeyLiteral = new MapKeyLiteral(stmt, mapping, value);
            }
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public MapKeyLiteral getKeyLiteral() {
        return this.mapKeyLiteral;
    }

    public MapValueLiteral getValueLiteral() {
        return this.mapValueLiteral;
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
    }

    public static class MapValueLiteral
    extends SQLExpression
    implements SQLLiteral {
        private final Map value;
        private List<SQLExpression> valueExpressions;

        public MapValueLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
            super(stmt, null, mapping);
            Map mapValue;
            if (!(value instanceof Map)) {
                throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
            }
            this.value = mapValue = (Map)value;
            this.setStatement();
        }

        public List<SQLExpression> getValueExpressions() {
            return this.valueExpressions;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setNotParameter() {
            if (this.parameterName == null) {
                return;
            }
            this.parameterName = null;
            this.st.clearStatement();
            this.setStatement();
        }

        protected void setStatement() {
            boolean isEmpty;
            boolean bl = isEmpty = this.value == null || this.value.size() == 0;
            if (!isEmpty) {
                RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
                this.valueExpressions = new ArrayList<SQLExpression>();
                this.st.append("(");
                boolean hadPrev = false;
                Collection values = this.value.values();
                for (Object current : values) {
                    if (null == current) continue;
                    JavaTypeMapping valueMapping = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                    SQLExpression valueExpr = storeMgr.getSQLExpressionFactory().newLiteral(this.stmt, valueMapping, current);
                    this.st.append(hadPrev ? "," : "");
                    this.st.append(valueExpr);
                    this.valueExpressions.add(valueExpr);
                    hadPrev = true;
                }
                this.st.append(")");
            }
        }
    }

    public static class MapKeyLiteral
    extends SQLExpression
    implements SQLLiteral {
        private final Map value;
        private List<SQLExpression> keyExpressions;

        public MapKeyLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
            super(stmt, null, mapping);
            Map mapValue;
            if (!(value instanceof Map)) {
                throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
            }
            this.value = mapValue = (Map)value;
            this.setStatement();
        }

        public List<SQLExpression> getKeyExpressions() {
            return this.keyExpressions;
        }

        @Override
        public SQLExpression invoke(String methodName, List args) {
            if (methodName.equals("get") && args.size() == 1) {
                SQLExpression argExpr = (SQLExpression)args.get(0);
                if (argExpr instanceof SQLLiteral) {
                    Object val = this.value.get(((SQLLiteral)((Object)argExpr)).getValue());
                    if (val == null) {
                        return new NullLiteral(this.stmt, null, null, null);
                    }
                    JavaTypeMapping m = this.stmt.getRDBMSManager().getSQLExpressionFactory().getMappingForType(val.getClass(), false);
                    return new ObjectLiteral(this.stmt, m, val, null);
                }
                throw new IllegalExpressionOperationException(this, "get", argExpr);
            }
            return super.invoke(methodName, args);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setNotParameter() {
            if (this.parameterName == null) {
                return;
            }
            this.parameterName = null;
            this.st.clearStatement();
            this.setStatement();
        }

        protected void setStatement() {
            boolean isEmpty;
            boolean bl = isEmpty = this.value == null || this.value.size() == 0;
            if (!isEmpty) {
                RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
                this.st.append("(");
                this.keyExpressions = new ArrayList<SQLExpression>();
                boolean hadPrev = false;
                Set keys = this.value.keySet();
                for (Object current : keys) {
                    if (null == current) continue;
                    JavaTypeMapping keyMapping = storeMgr.getSQLExpressionFactory().getMappingForType(current.getClass(), false);
                    SQLExpression keyExpr = storeMgr.getSQLExpressionFactory().newLiteral(this.stmt, keyMapping, current);
                    this.st.append(hadPrev ? "," : "");
                    this.st.append(keyExpr);
                    this.keyExpressions.add(keyExpr);
                    hadPrev = true;
                }
                this.st.append(")");
            }
        }
    }
}

