/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertifiedAttributesV2
extends ASN1Object {
    private static final Logger LOG = LoggerFactory.getLogger(CertifiedAttributesV2.class);
    private Object[] values;

    public static CertifiedAttributesV2 getInstance(Object o) {
        if (o instanceof CertifiedAttributesV2) {
            return (CertifiedAttributesV2)((Object)o);
        }
        if (o != null) {
            return new CertifiedAttributesV2(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    private CertifiedAttributesV2(ASN1Sequence seq) {
        int index = 0;
        this.values = new Object[seq.size()];
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(e.nextElement());
            if (taggedObject.getTagNo() == 0) {
                this.values[index] = AttributeCertificate.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)taggedObject, (boolean)true));
            } else if (taggedObject.getTagNo() == 1) {
                LOG.info("OtherAttributeCertificate detected");
            } else {
                throw new IllegalArgumentException("illegal tag: " + taggedObject.getTagNo());
            }
            ++index;
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != this.values.length; ++i) {
            if (this.values[i] instanceof AttributeCertificate) {
                v.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)((AttributeCertificate)this.values[i])));
                continue;
            }
            LOG.warn("Unsupported type : {}", this.values[i]);
        }
        return new DERSequence(v);
    }
}

