/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CadesLevelBaselineLTATimestampExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CadesLevelBaselineLTATimestampExtractor.class);
    private static final boolean OMIT_ALGORITHM_IDENTIFIER_IF_DEFAULT = true;
    private DigestAlgorithm hashIndexDigestAlgorithm;
    private final Set<ASN1ObjectIdentifier> excludedAttributesFromAtsHashIndex = new HashSet<ASN1ObjectIdentifier>();
    private final CMSSignedData cmsSignedData;
    private final Collection<CertificateToken> certificates;

    public CadesLevelBaselineLTATimestampExtractor(CAdESSignature cadesSignature) {
        this(cadesSignature.getCmsSignedData(), cadesSignature.getCompleteCertificateSource().getAllCertificateTokens());
        this.excludedAttributesFromAtsHashIndex.add(PKCSObjectIdentifiers.id_aa_ets_certValues);
        this.excludedAttributesFromAtsHashIndex.add(PKCSObjectIdentifiers.id_aa_ets_revocationValues);
    }

    public CadesLevelBaselineLTATimestampExtractor(CMSSignedData cmsSignedData, Collection<CertificateToken> certificates) {
        this.cmsSignedData = cmsSignedData;
        this.certificates = certificates;
    }

    public Attribute getAtsHashIndex(SignerInformation signerInformation, DigestAlgorithm hashIndexDigestAlgorithm, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        this.hashIndexDigestAlgorithm = hashIndexDigestAlgorithm;
        AlgorithmIdentifier algorithmIdentifier = this.getHashIndexDigestAlgorithmIdentifier();
        ASN1Sequence certificatesHashIndex = this.getCertificatesHashIndex();
        ASN1Sequence crLsHashIndex = this.getCRLsHashIndex();
        ASN1Sequence unsignedAttributesHashIndex = this.getUnsignedAttributesHashIndex(signerInformation, atsHashIndexVersionIdentifier);
        return this.getComposedAtsHashIndex(algorithmIdentifier, certificatesHashIndex, crLsHashIndex, unsignedAttributesHashIndex, atsHashIndexVersionIdentifier);
    }

    public Attribute getVerifiedAtsHashIndex(SignerInformation signerInformation, TimestampToken timestampToken) {
        ASN1ObjectIdentifier atsHashIndexVersionIdentifier;
        AttributeTable unsignedAttributes = timestampToken.getUnsignedAttributes();
        ASN1Sequence atsHashIndex = DSSASN1Utils.getAtsHashIndexByVersion((AttributeTable)unsignedAttributes, (ASN1ObjectIdentifier)(atsHashIndexVersionIdentifier = DSSASN1Utils.getAtsHashIndexVersionIdentifier((AttributeTable)unsignedAttributes)));
        if (atsHashIndex == null) {
            LOG.warn("A valid atsHashIndex [oid: {}] has not been found for a timestamp with id {}", (Object)atsHashIndexVersionIdentifier, (Object)timestampToken.getDSSIdAsString());
        }
        AlgorithmIdentifier derObjectAlgorithmIdentifier = this.getAlgorithmIdentifier(atsHashIndex);
        ASN1Sequence certificatesHashIndex = this.getVerifiedCertificatesHashIndex(atsHashIndex);
        ASN1Sequence crLsHashIndex = this.getVerifiedCRLsHashIndex(atsHashIndex);
        ASN1Sequence verifiedAttributesHashIndex = this.getVerifiedUnsignedAttributesHashIndex(signerInformation, atsHashIndex, atsHashIndexVersionIdentifier);
        return this.getComposedAtsHashIndex(derObjectAlgorithmIdentifier, certificatesHashIndex, crLsHashIndex, verifiedAttributesHashIndex, atsHashIndexVersionIdentifier);
    }

    private Attribute getComposedAtsHashIndex(AlgorithmIdentifier algorithmIdentifiers, ASN1Sequence certificatesHashIndex, ASN1Sequence crLsHashIndex, ASN1Sequence unsignedAttributesHashIndex, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (algorithmIdentifiers != null) {
            vector.add((ASN1Encodable)algorithmIdentifiers);
        } else if (OID.id_aa_ATSHashIndexV2.equals((ASN1Primitive)atsHashIndexVersionIdentifier) || OID.id_aa_ATSHashIndexV3.equals((ASN1Primitive)atsHashIndexVersionIdentifier)) {
            AlgorithmIdentifier sha256AlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(DigestAlgorithm.SHA256.getOid()));
            vector.add((ASN1Encodable)sha256AlgorithmIdentifier);
        }
        if (certificatesHashIndex != null) {
            vector.add((ASN1Encodable)certificatesHashIndex);
        }
        if (crLsHashIndex != null) {
            vector.add((ASN1Encodable)crLsHashIndex);
        }
        if (unsignedAttributesHashIndex != null) {
            vector.add((ASN1Encodable)unsignedAttributesHashIndex);
        }
        DERSequence derSequence = new DERSequence(vector);
        return new Attribute(atsHashIndexVersionIdentifier, (ASN1Set)new DERSet((ASN1Encodable)derSequence));
    }

    private ASN1Sequence getCertificatesHashIndex() {
        ASN1EncodableVector certificatesHashIndexVector = new ASN1EncodableVector();
        Collection<CertificateToken> certificateTokens = this.certificates;
        for (CertificateToken certificateToken : certificateTokens) {
            byte[] digest = certificateToken.getDigest(this.hashIndexDigestAlgorithm);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding to CertificatesHashIndex DSS-Identifier: {} with hash {}", (Object)certificateToken.getDSSId(), (Object)Utils.toHex((byte[])digest));
            }
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            certificatesHashIndexVector.add((ASN1Encodable)derOctetStringDigest);
        }
        return new DERSequence(certificatesHashIndexVector);
    }

    private ASN1Sequence getVerifiedCertificatesHashIndex(ASN1Sequence timestampHashIndex) {
        ASN1Sequence certHashes = DSSASN1Utils.getCertificatesHashIndex((ASN1Sequence)timestampHashIndex);
        List certHashesList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)certHashes);
        for (CertificateToken certificateToken : this.certificates) {
            byte[] digest = certificateToken.getDigest(this.hashIndexDigestAlgorithm);
            DEROctetString derOctetStringDigest = new DEROctetString(digest);
            if (certHashesList.remove(derOctetStringDigest)) {
                LOG.debug("Cert {} present in timestamp", (Object)certificateToken.getAbbreviation());
                continue;
            }
            LOG.debug("Cert {} not present in timestamp", (Object)certificateToken.getAbbreviation());
        }
        if (!certHashesList.isEmpty()) {
            LOG.error("{} attribute(s) hash in Cert Hashes has not been found in document attributes: {}", (Object)certHashesList.size(), (Object)certHashesList);
            return new DERSequence();
        }
        return certHashes;
    }

    private ASN1Sequence getCRLsHashIndex() {
        Enumeration crLs;
        ASN1EncodableVector crlsHashIndex = new ASN1EncodableVector();
        SignedData signedData = SignedData.getInstance((Object)this.cmsSignedData.toASN1Structure().getContent());
        ASN1Set signedDataCRLs = signedData.getCRLs();
        if (signedDataCRLs != null && (crLs = signedDataCRLs.getObjects()) != null) {
            while (crLs.hasMoreElements()) {
                ASN1Encodable asn1Encodable = (ASN1Encodable)crLs.nextElement();
                this.digestAndAddToList(crlsHashIndex, DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable));
            }
        }
        return new DERSequence(crlsHashIndex);
    }

    private void digestAndAddToList(ASN1EncodableVector crlsHashIndex, byte[] encoded) {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])encoded);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to crlsHashIndex with hash {}", (Object)Utils.toHex((byte[])digest));
        }
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        crlsHashIndex.add((ASN1Encodable)derOctetStringDigest);
    }

    private ASN1Sequence getVerifiedCRLsHashIndex(ASN1Sequence timestampHashIndex) {
        Enumeration crLs;
        ASN1Sequence crlHashes = DSSASN1Utils.getCRLHashIndex((ASN1Sequence)timestampHashIndex);
        List crlHashesList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)crlHashes);
        SignedData signedData = SignedData.getInstance((Object)this.cmsSignedData.toASN1Structure().getContent());
        ASN1Set signedDataCRLs = signedData.getCRLs();
        if (signedDataCRLs != null && (crLs = signedDataCRLs.getObjects()) != null) {
            while (crLs.hasMoreElements()) {
                ASN1Encodable asn1Encodable = (ASN1Encodable)crLs.nextElement();
                this.handleRevocationEncoded(crlHashesList, DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Encodable));
            }
        }
        if (!crlHashesList.isEmpty()) {
            LOG.error("{} attribute(s) hash in CRL Hashes has not been found in document attributes: {}", (Object)crlHashesList.size(), (Object)crlHashesList);
            return new DERSequence();
        }
        return crlHashes;
    }

    private void handleRevocationEncoded(List<DEROctetString> crlHashesList, byte[] revocationEncoded) {
        byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])revocationEncoded);
        DEROctetString derOctetStringDigest = new DEROctetString(digest);
        if (crlHashesList.remove(derOctetStringDigest)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("CRL/OCSP present in timestamp {}", (Object)DSSUtils.toHex((byte[])derOctetStringDigest.getOctets()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("CRL/OCSP not present in timestamp {}", (Object)DSSUtils.toHex((byte[])derOctetStringDigest.getOctets()));
        }
    }

    private ASN1Sequence getUnsignedAttributesHashIndex(SignerInformation signerInformation, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ASN1EncodableVector unsignedAttributesHashIndex = new ASN1EncodableVector();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            if (this.excludedAttributesFromAtsHashIndex.contains(attribute.getAttrType())) continue;
            List<DEROctetString> attributeDerOctetStringHashes = this.getAttributeDerOctetStringHashes(attribute, atsHashIndexVersionIdentifier);
            for (DEROctetString derOctetStringDigest : attributeDerOctetStringHashes) {
                unsignedAttributesHashIndex.add((ASN1Encodable)derOctetStringDigest);
            }
        }
        return new DERSequence(unsignedAttributesHashIndex);
    }

    private ASN1Sequence getVerifiedUnsignedAttributesHashIndex(SignerInformation signerInformation, ASN1Sequence timestampHashIndex, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        ASN1Sequence unsignedAttributesHashes = DSSASN1Utils.getUnsignedAttributesHashIndex((ASN1Sequence)timestampHashIndex);
        ArrayList timestampUnsignedAttributesHashesList = new ArrayList();
        if (unsignedAttributesHashes != null) {
            timestampUnsignedAttributesHashesList.addAll(Collections.list(unsignedAttributesHashes.getObjects()));
        }
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(signerInformation);
        ASN1EncodableVector asn1EncodableVector = unsignedAttributes.toASN1EncodableVector();
        for (int i = 0; i < asn1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)asn1EncodableVector.get(i);
            List<DEROctetString> attributeDerOctetStringHashes = this.getAttributeDerOctetStringHashes(attribute, atsHashIndexVersionIdentifier);
            for (DEROctetString derOctetStringDigest : attributeDerOctetStringHashes) {
                ASN1ObjectIdentifier attrType = attribute.getAttrType();
                if (timestampUnsignedAttributesHashesList.remove(derOctetStringDigest)) {
                    LOG.debug("Attribute {} present in timestamp", (Object)attrType.getId());
                    continue;
                }
                LOG.debug("Attribute {} not present in timestamp", (Object)attrType.getId());
            }
        }
        if (!timestampUnsignedAttributesHashesList.isEmpty()) {
            LOG.error("{} attribute(s) hash in Timestamp has not been found in document attributes: {}", (Object)timestampUnsignedAttributesHashesList.size(), timestampUnsignedAttributesHashesList);
            return new DERSequence();
        }
        return unsignedAttributesHashes;
    }

    private List<DEROctetString> getAttributeDerOctetStringHashes(Attribute attribute, ASN1ObjectIdentifier atsHashIndexVersionIdentifier) {
        List octets = DSSASN1Utils.getOctetStringForAtsHashIndex((Attribute)attribute, (ASN1ObjectIdentifier)atsHashIndexVersionIdentifier);
        if (Utils.isCollectionNotEmpty((Collection)octets)) {
            ArrayList<DEROctetString> derOctetStrings = new ArrayList<DEROctetString>();
            for (byte[] bytes : octets) {
                byte[] digest = DSSUtils.digest((DigestAlgorithm)this.hashIndexDigestAlgorithm, (byte[])bytes);
                derOctetStrings.add(new DEROctetString(digest));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Digest string [{}] has been added to the hash table", (Object)Utils.toHex((byte[])digest));
            }
            return derOctetStrings;
        }
        return Collections.emptyList();
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(ASN1Sequence atsHashIndexValue) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier((ASN1Sequence)atsHashIndexValue);
        this.hashIndexDigestAlgorithm = algorithmIdentifier != null ? DigestAlgorithm.forOID((String)algorithmIdentifier.getAlgorithm().getId()) : CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
        return algorithmIdentifier;
    }

    private AlgorithmIdentifier getHashIndexDigestAlgorithmIdentifier() {
        if (this.hashIndexDigestAlgorithm.getOid().equals(CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO.getOid())) {
            return null;
        }
        return DSSASN1Utils.getAlgorithmIdentifier((DigestAlgorithm)this.hashIndexDigestAlgorithm);
    }

    public byte[] getArchiveTimestampDataV3(SignerInformation signerInformation, Attribute atsHashIndexAttribute, byte[] originalDocumentDigest) {
        byte[] encodedContentType = this.getEncodedContentType(this.cmsSignedData);
        byte[] signedDataDigest = originalDocumentDigest;
        byte[] encodedFields = this.getSignedFields(signerInformation);
        byte[] encodedAtsHashIndex = DSSASN1Utils.getDEREncoded((ASN1Encodable)atsHashIndexAttribute.getAttrValues().getObjectAt(0));
        byte[] dataToTimestamp = DSSUtils.concatenate((byte[][])new byte[][]{encodedContentType, signedDataDigest, encodedFields, encodedAtsHashIndex});
        if (LOG.isDebugEnabled()) {
            LOG.debug("eContentType={}", encodedContentType != null ? (Object)Utils.toHex((byte[])encodedContentType) : encodedContentType);
            LOG.debug("signedDataDigest={}", signedDataDigest != null ? (Object)Utils.toHex((byte[])signedDataDigest) : signedDataDigest);
            LOG.debug("encodedFields=see above");
            LOG.debug("encodedAtsHashIndex={}", encodedAtsHashIndex != null ? (Object)Utils.toHex((byte[])encodedAtsHashIndex) : encodedAtsHashIndex);
            LOG.debug("Archive Timestamp Data v3 is: {}", dataToTimestamp != null ? (Object)Utils.toHex((byte[])dataToTimestamp) : dataToTimestamp);
        }
        return dataToTimestamp;
    }

    private byte[] getEncodedContentType(CMSSignedData cmsSignedData) {
        ContentInfo contentInfo = cmsSignedData.toASN1Structure();
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        return DSSASN1Utils.getDEREncoded((ASN1Encodable)signedData.getEncapContentInfo().getContentType());
    }

    private byte[] getSignedFields(SignerInformation signerInformation) {
        SignerInfo signerInfo = signerInformation.toASN1Structure();
        ASN1Integer version = signerInfo.getVersion();
        SignerIdentifier sid = signerInfo.getSID();
        AlgorithmIdentifier digestAlgorithm = signerInfo.getDigestAlgorithm();
        DERTaggedObject signedAttributes = CMSUtils.getDERSignedAttributes(signerInformation);
        AlgorithmIdentifier digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        ASN1OctetString encryptedDigest = signerInfo.getEncryptedDigest();
        byte[] derEncodedVersion = DSSASN1Utils.getDEREncoded((ASN1Encodable)version);
        byte[] derEncodedSid = DSSASN1Utils.getDEREncoded((ASN1Encodable)sid);
        byte[] derEncodedDigestAlgorithm = DSSASN1Utils.getDEREncoded((ASN1Encodable)digestAlgorithm);
        byte[] derEncodedSignedAttributes = DSSASN1Utils.getDEREncoded((ASN1Encodable)signedAttributes);
        byte[] derEncodedDigestEncryptionAlgorithm = DSSASN1Utils.getDEREncoded((ASN1Encodable)digestEncryptionAlgorithm);
        byte[] derEncodedEncryptedDigest = DSSASN1Utils.getDEREncoded((ASN1Encodable)encryptedDigest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSignedFields Version={}", (Object)Utils.toBase64((byte[])derEncodedVersion));
            LOG.debug("getSignedFields Sid={}", (Object)Utils.toBase64((byte[])derEncodedSid));
            LOG.debug("getSignedFields DigestAlgorithm={}", (Object)Utils.toBase64((byte[])derEncodedDigestAlgorithm));
            LOG.debug("getSignedFields SignedAttributes={}", (Object)Utils.toBase64((byte[])derEncodedSignedAttributes));
            LOG.debug("getSignedFields DigestEncryptionAlgorithm={}", (Object)Utils.toBase64((byte[])derEncodedDigestEncryptionAlgorithm));
            LOG.debug("getSignedFields EncryptedDigest={}", (Object)Utils.toBase64((byte[])derEncodedEncryptedDigest));
        }
        return DSSUtils.concatenate((byte[][])new byte[][]{derEncodedVersion, derEncodedSid, derEncodedDigestAlgorithm, derEncodedSignedAttributes, derEncodedDigestEncryptionAlgorithm, derEncodedEncryptedDigest});
    }
}

