/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ISignatureAttribute;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESAttribute
implements ISignatureAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESAttribute.class);
    private final Attribute attribute;

    CAdESAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public ASN1ObjectIdentifier getASN1Oid() {
        return this.attribute.getAttrType();
    }

    private List<ASN1Primitive> getASN1Primitives() {
        ArrayList<ASN1Primitive> primitives = new ArrayList<ASN1Primitive>();
        ASN1Set attrValues = this.attribute.getAttrValues();
        for (ASN1Encodable value : attrValues.toArray()) {
            if (value instanceof DEROctetString) {
                LOG.warn("Illegal content for timestamp (OID : {}) : OCTET STRING is not allowed !", (Object)this);
                continue;
            }
            primitives.add(value.toASN1Primitive());
        }
        return primitives;
    }

    public ASN1Primitive getASN1Primitive() {
        List<ASN1Primitive> asn1Primitives = this.getASN1Primitives();
        if (Utils.isCollectionNotEmpty(asn1Primitives)) {
            if (asn1Primitives.size() > 1) {
                LOG.warn("More than one result in CAdES attribute with OID: [{}]. Return only the first one", (Object)this);
            }
            return asn1Primitives.get(0);
        }
        return null;
    }

    public ASN1Encodable getASN1Object() {
        return this.attribute.getAttrValues().getObjectAt(0);
    }

    public TimeStampToken toTimeStampToken() {
        try {
            return DSSASN1Utils.getTimeStampToken((Attribute)this.attribute);
        }
        catch (Exception e) {
            LOG.warn("Unable to build a timestamp token from the attribute [{}] : {}", (Object)this, (Object)e.getMessage());
            return null;
        }
    }

    public String toString() {
        ASN1ObjectIdentifier asn1Oid = this.getASN1Oid();
        if (asn1Oid != null) {
            return asn1Oid.toString();
        }
        return "";
    }
}

