/*
 *
 * Copyright 2017-2018 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.exceptions;

/**
 * Exception thrown when an object is not uniquely identifiable.
 *
 *
 * @since 1.0
 * @author Anindya Chatterjee
 */
public class NotIdentifiableException extends NitriteException {
    /**
     * Instantiates a new Not identifiable exception.
     *
     * @param message the message
     */
    public NotIdentifiableException(ErrorMessage message) {
        super(message);
    }
}
