/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.iterables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Deprecated
public final class CachingIterable<T>
implements Iterable<T> {
    private final List<T> mCache = new ArrayList<T>(64);
    private final Iterator<T> mSourceIterator;
    private boolean mComplete;

    public CachingIterable(Iterator<T> iterator) {
        this.mSourceIterator = iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        if (!this.mComplete) {
            Iterator<T> iterator = this.mSourceIterator;
            synchronized (iterator) {
                if (this.mSourceIterator.hasNext()) {
                    return new SynchronizedCachingIterator<T>(this.mSourceIterator, this.mCache, this.mCache.size());
                }
                this.mComplete = true;
            }
        }
        return Collections.unmodifiableList(this.mCache).iterator();
    }

    private static final class SynchronizedCachingIterator<T>
    implements Iterator<T> {
        private final Iterator<T> mOriginalIterator;
        private final List<T> mCache;
        private final int mSafeElements;
        private int mPos;

        public SynchronizedCachingIterator(Iterator<T> originalIterator, List<T> cache, int safeElements) {
            this.mOriginalIterator = originalIterator;
            this.mCache = cache;
            this.mSafeElements = safeElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.mPos < this.mSafeElements) {
                return true;
            }
            Iterator<T> iterator = this.mOriginalIterator;
            synchronized (iterator) {
                return this.mPos < this.mCache.size() || this.mOriginalIterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Iterator<T> iterator = this.mOriginalIterator;
            synchronized (iterator) {
                if (this.mPos == this.mCache.size()) {
                    T next = this.mOriginalIterator.next();
                    this.mCache.add(next);
                    ++this.mPos;
                    return next;
                }
                return this.mCache.get(this.mPos++);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported by this Iterator.");
        }
    }
}

