/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.org.xhtmlrenderer.extend.FSImage;
import org.docx4j.org.xhtmlrenderer.extend.ReplacedElement;
import org.docx4j.org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.docx4j.org.xhtmlrenderer.extend.UserAgentCallback;
import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.pdf.BookmarkElement;
import org.docx4j.org.xhtmlrenderer.pdf.ITextImageElement;
import org.docx4j.org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.docx4j.org.xhtmlrenderer.pdf.RadioButtonFormField;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ITextReplacedElementFactory
implements ReplacedElementFactory {
    private ITextOutputDevice _outputDevice;
    private Map _radioButtonsByElem = new HashMap();
    private Map _radioButtonsByName = new HashMap();

    public ITextReplacedElementFactory(ITextOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            FSImage fsImage = uac.getImageResource(e.getAttribute("src")).getImage();
            if (fsImage != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        } else if (nodeName.equals("bookmark")) {
            BookmarkElement result = new BookmarkElement();
            if (e.hasAttribute("name")) {
                String name = e.getAttribute("name");
                c.addBoxId(name, box);
                result.setAnchorName(name);
            }
            return result;
        }
        return null;
    }

    private boolean isTextarea(Element e) {
        if (!e.getNodeName().equals("textarea")) {
            return false;
        }
        Node n = e.getFirstChild();
        while (n != null) {
            short nodeType = n.getNodeType();
            if (nodeType == 3 || nodeType == 4) continue;
            return false;
        }
        return true;
    }

    private void saveResult(Element e, RadioButtonFormField result) {
        this._radioButtonsByElem.put(e, result);
        String fieldName = result.getFieldName(this._outputDevice, e);
        ArrayList<RadioButtonFormField> fields = (ArrayList<RadioButtonFormField>)this._radioButtonsByName.get(fieldName);
        if (fields == null) {
            fields = new ArrayList<RadioButtonFormField>();
            this._radioButtonsByName.put(fieldName, fields);
        }
        fields.add(result);
    }

    public void reset() {
        this._radioButtonsByElem = new HashMap();
        this._radioButtonsByName = new HashMap();
    }

    public void remove(Element e) {
        String fieldName;
        List values;
        RadioButtonFormField field = (RadioButtonFormField)this._radioButtonsByElem.remove(e);
        if (field != null && (values = (List)this._radioButtonsByName.get(fieldName = field.getFieldName(this._outputDevice, e))) != null) {
            values.remove(field);
            if (values.size() == 0) {
                this._radioButtonsByName.remove(fieldName);
            }
        }
    }

    public void remove(String fieldName) {
        List values = (List)this._radioButtonsByName.get(fieldName);
        if (values != null) {
            for (RadioButtonFormField field : values) {
                this._radioButtonsByElem.remove(field.getBox().getElement());
            }
        }
        this._radioButtonsByName.remove(fieldName);
    }

    public List getRadioButtons(String name) {
        return (List)this._radioButtonsByName.get(name);
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }
}

