/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.render;

import java.util.List;
import org.docx4j.org.xhtmlrenderer.css.style.CalculatedStyle;
import org.docx4j.org.xhtmlrenderer.css.style.CssContext;
import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.layout.Styleable;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.Box;
import org.w3c.dom.Element;

public class AnonymousBlockBox
extends BlockBox {
    private List _openInlineBoxes;

    public AnonymousBlockBox(Element element) {
        this.setElement(element);
    }

    public void layout(LayoutContext c) {
        this.layoutInlineChildren(c, 0, this.calcInitialBreakAtLine(c), true);
    }

    public int getContentWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result = super.find(cssCtx, absX, absY, findAnonymous);
        if (!findAnonymous && result == this) {
            return this.getParent();
        }
        return result;
    }

    public List getOpenInlineBoxes() {
        return this._openInlineBoxes;
    }

    public void setOpenInlineBoxes(List openInlineBoxes) {
        this._openInlineBoxes = openInlineBoxes;
    }

    public boolean isSkipWhenCollapsingMargins() {
        for (Styleable styleable : this.getInlineContent()) {
            CalculatedStyle style = styleable.getStyle();
            if (style.isFloated() || style.isAbsolute() || style.isFixed() || style.isRunning()) continue;
            return false;
        }
        return true;
    }

    public void provideSiblingMarginToFloats(int margin) {
        for (Styleable styleable : this.getInlineContent()) {
            BlockBox b;
            if (!(styleable instanceof BlockBox) || !(b = (BlockBox)styleable).isFloated()) continue;
            b.getFloatedBoxData().setMarginFromSibling(margin);
        }
    }

    public boolean isMayCollapseMarginsWithChildren() {
        return false;
    }

    public void styleText(LayoutContext c) {
        this.styleText(c, this.getParent().getStyle());
    }

    public BlockBox copyOf() {
        throw new IllegalArgumentException("cannot be copied");
    }
}

