/**
 * Copyright (c) 2004-2011 QOS.ch All rights reserved.
 *
 * <p>Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * <p>The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * <p>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package org.slf4j.helpers;

import org.slf4j.Marker;

/**
 * This class serves as base for adapters or native implementations of logging systems lacking
 * Marker support. In this implementation, methods taking marker data simply invoke the
 * corresponding method without the Marker argument, discarding any marker data passed as argument.
 *
 * @author Ceki Gulcu
 */
public abstract class MarkerIgnoringBase extends NamedLoggerBase implements org.slf4j.Logger {

  private static final long serialVersionUID = 9044267456635152283L;

  public boolean isTraceEnabled(Marker marker) {
    return isTraceEnabled();
  }

  public void trace(Marker marker, String msg) {
    trace(msg);
  }

  public void trace(Marker marker, String format, Object arg) {
    trace(format, arg);
  }

  public void trace(Marker marker, String format, Object arg1, Object arg2) {
    trace(format, arg1, arg2);
  }

  public void trace(Marker marker, String format, Object... arguments) {
    trace(format, arguments);
  }

  public void trace(Marker marker, String msg, Throwable t) {
    trace(msg, t);
  }

  public boolean isDebugEnabled(Marker marker) {
    return isDebugEnabled();
  }

  public void debug(Marker marker, String msg) {
    debug(msg);
  }

  public void debug(Marker marker, String format, Object arg) {
    debug(format, arg);
  }

  public void debug(Marker marker, String format, Object arg1, Object arg2) {
    debug(format, arg1, arg2);
  }

  public void debug(Marker marker, String format, Object... arguments) {
    debug(format, arguments);
  }

  public void debug(Marker marker, String msg, Throwable t) {
    debug(msg, t);
  }

  public boolean isInfoEnabled(Marker marker) {
    return isInfoEnabled();
  }

  public void info(Marker marker, String msg) {
    info(msg);
  }

  public void info(Marker marker, String format, Object arg) {
    info(format, arg);
  }

  public void info(Marker marker, String format, Object arg1, Object arg2) {
    info(format, arg1, arg2);
  }

  public void info(Marker marker, String format, Object... arguments) {
    info(format, arguments);
  }

  public void info(Marker marker, String msg, Throwable t) {
    info(msg, t);
  }

  public boolean isWarnEnabled(Marker marker) {
    return isWarnEnabled();
  }

  public void warn(Marker marker, String msg) {
    warn(msg);
  }

  public void warn(Marker marker, String format, Object arg) {
    warn(format, arg);
  }

  public void warn(Marker marker, String format, Object arg1, Object arg2) {
    warn(format, arg1, arg2);
  }

  public void warn(Marker marker, String format, Object... arguments) {
    warn(format, arguments);
  }

  public void warn(Marker marker, String msg, Throwable t) {
    warn(msg, t);
  }

  public boolean isErrorEnabled(Marker marker) {
    return isErrorEnabled();
  }

  public void error(Marker marker, String msg) {
    error(msg);
  }

  public void error(Marker marker, String format, Object arg) {
    error(format, arg);
  }

  public void error(Marker marker, String format, Object arg1, Object arg2) {
    error(format, arg1, arg2);
  }

  public void error(Marker marker, String format, Object... arguments) {
    error(format, arguments);
  }

  public void error(Marker marker, String msg, Throwable t) {
    error(msg, t);
  }

  public String toString() {
    return this.getClass().getName() + "(" + getName() + ")";
  }
}
