/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.Condition;
import org.drools.model.ConditionalConsequence;
import org.drools.model.Consequence;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItem;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.impl.Exchange;
import org.drools.model.impl.NamesGenerator;
import org.drools.model.impl.ViewBuilder;
import org.drools.model.impl.ViewFlowBuilder;
import org.drools.model.patterns.AccumulatePatternImpl;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.EvalImpl;
import org.drools.model.patterns.ExistentialPatternImpl;
import org.drools.model.patterns.PatternImpl;
import org.drools.model.patterns.QueryCallPattern;
import org.drools.model.view.AccumulateExprViewItem;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ExistentialExprViewItem;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.FixedValueItem;
import org.drools.model.view.QueryCallViewItem;
import org.drools.model.view.ViewItem;

public class ViewPatternBuilder
implements ViewBuilder {
    ViewPatternBuilder() {
    }

    @Override
    public CompositePatterns apply(RuleItemBuilder<?>[] viewItemBuilders) {
        List ruleItems = Stream.of(viewItemBuilders).map(RuleItemBuilder::get).collect(Collectors.toList());
        Iterator ruleItemIterator = ruleItems.iterator();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        LinkedHashMap<String, Consequence> consequences = new LinkedHashMap<String, Consequence>();
        while (ruleItemIterator.hasNext()) {
            RuleItem ruleItem = (RuleItem)ruleItemIterator.next();
            if (ruleItem instanceof Consequence) {
                Consequence consequence = (Consequence)ruleItem;
                String name = ruleItemIterator.hasNext() ? NamesGenerator.generateName("consequence") : "default";
                consequences.put(name, consequence);
                conditions.add(new NamedConsequenceImpl(name, consequence.isBreaking()));
                continue;
            }
            if (ruleItem instanceof ConditionalConsequence) {
                conditions.add(ViewFlowBuilder.createConditionalNamedConsequence(consequences, (ConditionalConsequence)ruleItem));
                continue;
            }
            conditions.add(ViewPatternBuilder.ruleItem2Condition(ruleItem));
        }
        return new CompositePatterns(Condition.Type.AND, conditions, consequences);
    }

    private static Condition ruleItem2Condition(RuleItem ruleItem) {
        if (ruleItem instanceof PatternDSL.PatternDefImpl) {
            Variable patternVariable;
            PatternDSL.PatternDefImpl patternDef = (PatternDSL.PatternDefImpl)ruleItem;
            PatternImpl pattern = new PatternImpl(patternVariable, (patternVariable = patternDef.getFirstVariable()) instanceof Exchange ? Condition.Type.RECEIVER : Condition.Type.PATTERN);
            for (PatternDSL.PatternItem patternItem : patternDef.getItems()) {
                if (patternItem instanceof PatternDSL.PatternExprImpl) {
                    pattern.addConstraint(((PatternDSL.PatternExprImpl)patternItem).asConstraint(patternDef));
                    continue;
                }
                if (patternItem instanceof PatternDSL.PatternBindingImpl) {
                    pattern.addBinding(((PatternDSL.PatternBindingImpl)patternItem).asBinding(patternDef));
                    continue;
                }
                throw new UnsupportedOperationException("Unknown pattern item type: " + patternItem);
            }
            pattern.addWatchedProps(patternDef.getWatch());
            return pattern;
        }
        if (ruleItem instanceof FixedValueItem) {
            return new EvalImpl(((FixedValueItem)ruleItem).isValue());
        }
        if (ruleItem instanceof QueryCallViewItem) {
            return new QueryCallPattern((QueryCallViewItem)ruleItem);
        }
        if (ruleItem instanceof CombinedExprViewItem) {
            CombinedExprViewItem combined = (CombinedExprViewItem)ruleItem;
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (ViewItem expr : combined.getExpressions()) {
                conditions.add(ViewPatternBuilder.ruleItem2Condition(expr));
            }
            return new CompositePatterns(combined.getType(), conditions);
        }
        if (ruleItem instanceof ExistentialExprViewItem) {
            ExistentialExprViewItem existential = (ExistentialExprViewItem)ruleItem;
            return new ExistentialPatternImpl(ViewPatternBuilder.ruleItem2Condition(existential.getExpression()), existential.getType());
        }
        if (ruleItem instanceof AccumulateExprViewItem) {
            AccumulateExprViewItem acc = (AccumulateExprViewItem)ruleItem;
            return new AccumulatePatternImpl(ViewPatternBuilder.ruleItem2Condition(acc.getExpr()), acc.getAccumulateFunctions());
        }
        if (ruleItem instanceof ExprViewItem) {
            return new EvalImpl(ViewFlowBuilder.createConstraint((ExprViewItem)ruleItem));
        }
        if (ruleItem instanceof PatternDSL.ExchangeDefImpl) {
            PatternDSL.ExchangeDefImpl exchangeDef = (PatternDSL.ExchangeDefImpl)ruleItem;
            return new PatternImpl(exchangeDef.getFirstVariable(), Condition.Type.SENDER);
        }
        throw new UnsupportedOperationException("Unknown " + ruleItem);
    }
}

