/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.Condition;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.consequences.ConditionalNamedConsequenceImpl;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.impl.ModelComponent;
import org.drools.model.patterns.PatternImpl;

public class CompositePatterns
implements Condition,
View,
ModelComponent {
    private final Condition.Type type;
    private final List<Condition> patterns;
    private final Set<Variable<?>> usedVars;
    private final Map<String, Consequence> consequences;

    public CompositePatterns(Condition.Type type, List<Condition> patterns) {
        this(type, patterns, null, null);
    }

    public CompositePatterns(Condition.Type type, List<Condition> patterns, Map<String, Consequence> consequences) {
        this(type, patterns, null, consequences);
    }

    public CompositePatterns(Condition.Type type, List<Condition> patterns, Set<Variable<?>> usedVars, Map<String, Consequence> consequences) {
        this.type = type;
        this.patterns = patterns;
        this.usedVars = usedVars;
        this.consequences = consequences;
    }

    @Override
    public Variable<?>[] getBoundVariables() {
        return (Variable[])this.patterns.stream().flatMap(c -> Stream.of(c.getBoundVariables())).distinct().toArray(Variable[]::new);
    }

    public Map<String, Consequence> getConsequences() {
        return this.consequences;
    }

    @Override
    public List<Condition> getSubConditions() {
        return this.patterns;
    }

    public void addCondition(Condition condition) {
        this.patterns.add(condition);
    }

    public void addCondition(int index, Condition condition) {
        this.patterns.add(index, condition);
    }

    @Override
    public Condition.Type getType() {
        return this.type;
    }

    public void ensureVariablesDeclarationInView() {
        this.getConsequences().forEach(this::ensureVariablesDeclarationInView);
    }

    public void ensureVariablesDeclarationInView(String name, Consequence consequence) {
        for (Variable variable : consequence.getDeclarations()) {
            if (!this.usedVars.add(variable)) continue;
            this.patterns.add(this.getConsequencePosition(name), new PatternImpl(variable));
        }
    }

    private int getConsequencePosition(String name) {
        if ("default".equals(name)) {
            return this.patterns.size() - 1;
        }
        int result = 0;
        for (Condition condition : this.patterns) {
            if (condition instanceof NamedConsequenceImpl && ((NamedConsequenceImpl)condition).getName().equals(name)) {
                return result;
            }
            if (condition instanceof ConditionalNamedConsequenceImpl && ((ConditionalNamedConsequenceImpl)condition).getThenConsequence().getName().equals(name)) {
                return result - 1;
            }
            ++result;
        }
        throw new IllegalArgumentException("Cannot find consequence with name " + name);
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositePatterns)) {
            return false;
        }
        CompositePatterns patterns1 = (CompositePatterns)o;
        if (this.type != patterns1.type) {
            return false;
        }
        if (!ModelComponent.areEqualInModel(this.patterns, patterns1.patterns)) {
            return false;
        }
        return ModelComponent.areEqualInModel(this.consequences, patterns1.consequences);
    }

    public String toString() {
        return "CompositePatterns of " + this.type + " (vars: " + this.usedVars + ", patterns: " + this.patterns + ", consequences: " + this.consequences + ")";
    }

    @Override
    public CompositePatterns cloneCondition() {
        return new CompositePatterns(this.type, this.patterns.stream().map(Condition::cloneCondition).collect(Collectors.toList()), this.usedVars == null ? null : new HashSet(this.usedVars), (Map<String, Consequence>)(this.consequences == null ? null : new HashMap<String, Consequence>(this.consequences)));
    }
}

